/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.Serializable;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.security.sasl.Sasl;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.service.authentication.PlainSASLHelper;
import org.apache.kyuubi.service.authentication.PlainSASLServer;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.thrift.TProcessorFactory;
import org.apache.kyuubi.shaded.thrift.transport.TSaslClientTransport;
import org.apache.kyuubi.shaded.thrift.transport.TSaslServerTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportFactory;
import scala.Function0;
import scala.None$;
import scala.Option;

public final class PlainSASLHelper$ {
    public static final PlainSASLHelper$ MODULE$ = new PlainSASLHelper$();

    static {
        Security.addProvider(new PlainSASLServer.SaslPlainProvider());
    }

    public TProcessorFactory getProcessFactory(TCLIService.Iface service) {
        return new PlainSASLHelper.SQLPlainProcessorFactory(service);
    }

    public TTransportFactory getTransportFactory(String authTypeStr, KyuubiConf conf, Option<TSaslServerTransport.Factory> transportFactory, boolean isServer) {
        PlainSASLHelper.PlainServerCallbackHandler plainServerCallbackHandler;
        try {
            plainServerCallbackHandler = new PlainSASLHelper.PlainServerCallbackHandler(authTypeStr, conf, isServer);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Illegal authentication type ").append(authTypeStr).append(" for plain transport").toString());
        }
        PlainSASLHelper.PlainServerCallbackHandler handler = plainServerCallbackHandler;
        TSaslServerTransport.Factory saslFactory = (TSaslServerTransport.Factory)transportFactory.getOrElse((Function0 & Serializable)() -> {
            TSaslServerTransport.Factory _factory = new TSaslServerTransport.Factory();
            _factory.setSaslServerFactory(d -> {
                String string = d.mechanism;
                String string2 = "PLAIN";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    PlainSASLServer.SaslPlainServerFactory kyuubiFactory = new PlainSASLServer.SaslPlainServerFactory();
                    return kyuubiFactory.createSaslServer(d.mechanism, d.protocol, d.serverName, d.props, d.cbh);
                }
                return Sasl.createSaslServer(d.mechanism, d.protocol, d.serverName, d.props, d.cbh);
            });
            return _factory;
        });
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.apache.kyuubi.service.name", isServer ? "SERVER" : "ENGINE");
        saslFactory.addServerDefinition("PLAIN", authTypeStr, null, props, handler);
        return saslFactory;
    }

    public Option<TSaslServerTransport.Factory> getTransportFactory$default$3() {
        return None$.MODULE$;
    }

    public boolean getTransportFactory$default$4() {
        return true;
    }

    public TTransport getPlainTransport(String user, String password, TTransport underlyingTransport) {
        PlainSASLHelper.PlainCallBackHandler callBackHandler = new PlainSASLHelper.PlainCallBackHandler(user, password);
        return new TSaslClientTransport("PLAIN", null, null, null, Collections.emptyMap(), callBackHandler, underlyingTransport);
    }

    private PlainSASLHelper$() {
    }
}

