/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.TempFileService;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001\u0002$H\u0001AC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006G\u0002!\ta\u001a\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0019\b\u0001)A\u0005U\"9A\u000f\u0001b\u0001\n\u0003)\bB\u0002?\u0001A\u0003%a\u000fC\u0004~\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005-\u0001\u0001)A\u0005\u007f\"I\u0011Q\u0002\u0001A\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0001\u0019!C\u0001\u0003SA\u0001\"!\u000e\u0001A\u0003&\u0011\u0011\u0003\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0004C\u0006\u0002H\u0001\u0001\r\u00111A\u0005\u0002\u0005%\u0003bCA'\u0001\u0001\u0007\t\u0011)Q\u0005\u0003wA!\"a\u0014\u0001\u0011\u000b\u0007I\u0011AA)\u0011)\t\t\b\u0001EC\u0002\u0013\u0005\u00111\u000f\u0005\n\u0003w\u0002\u0001\u0019!C\u0005\u0003{B\u0011\"a\"\u0001\u0001\u0004%I!!#\t\u0011\u00055\u0005\u0001)Q\u0005\u0003\u007fB\u0011\"a$\u0001\u0001\u0004%I!! \t\u0013\u0005E\u0005\u00011A\u0005\n\u0005M\u0005\u0002CAL\u0001\u0001\u0006K!a \t\u0019\u0005M\u0002\u0001%A\t\b\u0004&I!!'\t\u0015\u0005]\u0006\u0001#b\u0001\n\u0003\tI\f\u0003\u0006\u0002<\u0002A)\u0019!C\u0001\u0003{C\u0011\"a0\u0001\u0001\u0004%\t!!1\t\u0013\u0005U\u0007\u00011A\u0005\u0002\u0005]\u0007\u0002CAn\u0001\u0001\u0006K!a1\t\u0013\u0005u\u0007A1A\u0005\n\u0005}\u0007\u0002CAt\u0001\u0001\u0006I!!9\t\u0013\u0005%\bA1A\u0005\u0002\u0005-\b\u0002CA}\u0001\u0001\u0006I!!<\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9!q\u0002\u0001\u0005R\tE\u0001b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u0005?\u0002A\u0011\tB1\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SB\u0011Ba+\u0001#\u0003%\tA!,\t\u0011\t\r\u0007\u0001\"\u0001J\u0005\u000bDqAa1\u0001\t\u0003\u0011Y\rC\u0004\u0003n\u0002!\tAa<\t\u000f\te\b\u0001\"\u0001\u0003|\"91\u0011\u0001\u0001\u0005\u0002\r\r\u0001bBB\u0004\u0001\u0011\u00051\u0011\u0002\u0005\b\u0007\u001b\u0001A\u0011AB\b\u0011\u001d\u0019i\u0002\u0001C\u0001\u0007?Aqaa\t\u0001\t\u0003\u0019)\u0003C\u0004\u00044\u0001!\ta!\u000e\t\u0013\rU\u0003!%A\u0005\u0002\r]\u0003bBB.\u0001\u0011\u00051Q\f\u0005\b\u0007C\u0002A\u0011AB2\u0011\u001d\u0019\t\t\u0001C!\u0007\u0007Cqa!\"\u0001\t\u0003\u00199\tC\u0004\u0004\u0010\u0002!\ta!%\t\u000f\re\u0005\u0001\"\u0003\u0004\u001c\"91q\u0014\u0001\u0005\u0002\r\u0005\u0006bBBU\u0001\u0011\u000511\u0016\u0005\b\u0007c\u0003A\u0011KBZ\u0011\u001d\u0019)\f\u0001C\u0005\u0007oC\u0001ba/\u0001\t\u0003I5Q\u0018\u0005\t\u0007\u000b\u0004A\u0011A%\u0004H\"A11\u001a\u0001\u0005\u0002%\u001bi\f\u0003\u0005\u0004N\u0002!\t!SBh\u0011!\u0019\u0019\u000e\u0001C\u0001\u0013\u000eu\u0006\u0002CBk\u0001\u0011\u0005\u0011ja6\t\u000f\rm\u0007\u0001\"\u0003\u0004^\"91q\u001f\u0001\u0005\n\r\r\u0005bBB}\u0001\u0011%11 \u0002\u0015\u0017f,XOY5TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005!K\u0015aB:fgNLwN\u001c\u0006\u0003\u0015.\u000baa[=vk\nL'B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#B\u0011!kU\u0007\u0002\u000f&\u0011Ak\u0012\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0003\u0011q\u0017-\\3\u0011\u0005]\u0003gB\u0001-_!\tIF,D\u0001[\u0015\tYv*\u0001\u0004=e>|GO\u0010\u0006\u0002;\u0006)1oY1mC&\u0011q\fX\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`9\u00061A(\u001b8jiz\"\"!\u001a4\u0011\u0005I\u0003\u0001\"B+\u0003\u0001\u00041F#A3\u0002\rA\f'o]3s+\u0005Q\u0007CA6r\u001b\u0005a'BA7o\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001n\u001c\u0006\u0003a&\u000b1a]9m\u0013\t\u0011HN\u0001\u0007LsV,(-\u001b)beN,'/A\u0004qCJ\u001cXM\u001d\u0011\u0002!=\u0004XM]1uS>tW*\u00198bO\u0016\u0014X#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005eL\u0015!C8qKJ\fG/[8o\u0013\tY\bP\u0001\fLsV,(-[(qKJ\fG/[8o\u001b\u0006t\u0017mZ3s\u0003Ey\u0007/\u001a:bi&|g.T1oC\u001e,'\u000fI\u0001\u0013GJ,G-\u001a8uS\u0006d7/T1oC\u001e,'/F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\u0013\u0006Y1M]3eK:$\u0018.\u00197t\u0013\u0011\tI!a\u0001\u00031!\u000bGm\\8q\u0007J,G-\u001a8uS\u0006d7/T1oC\u001e,'/A\nde\u0016$WM\u001c;jC2\u001cX*\u00198bO\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005U\u0011\u0011D\u0007\u00029&\u0019\u0011q\u0003/\u0003\r=\u0003H/[8o!\u0011\tY\"a\t\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003[&KA!!\n\u0002\u001e\tyQ*\u001a;bI\u0006$\u0018-T1oC\u001e,'/A\nnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0002\u0003BA\n\u0003[I1!a\f]\u0005\u0011)f.\u001b;\t\u0013\u0005M2\"!AA\u0002\u0005E\u0011a\u0001=%c\u0005\u0001R.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fI\u0001\u0013CB\u0004H.[2bi&|g.T1oC\u001e,'/\u0006\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B%\u000ba!\u001a8hS:,\u0017\u0002BA#\u0003\u007f\u0011\u0001dS=vk\nL\u0017\t\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3s\u0003Y\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8NC:\fw-\u001a:`I\u0015\fH\u0003BA\u0016\u0003\u0017B\u0011\"a\r\u000f\u0003\u0003\u0005\r!a\u000f\u0002'\u0005\u0004\b\u000f\\5dCRLwN\\'b]\u0006<WM\u001d\u0011\u0002%M,7o]5p]\u000e{gNZ!em&\u001cxN]\u000b\u0003\u0003'\u0002b!!\u0016\u0002`\u0005\u0015d\u0002BA,\u00037r1!WA-\u0013\u0005i\u0016bAA/9\u00069\u0001/Y2lC\u001e,\u0017\u0002BA1\u0003G\u00121aU3r\u0015\r\ti\u0006\u0018\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N%\u0002\rAdWoZ5o\u0013\u0011\ty'!\u001b\u0003%M+7o]5p]\u000e{gNZ!em&\u001cxN]\u0001\u000eOJ|W\u000f\u001d)s_ZLG-\u001a:\u0016\u0005\u0005U\u0004\u0003BA4\u0003oJA!!\u001f\u0002j\tiqI]8vaB\u0013xN^5eKJ\fq\u0001\\5nSR,'/\u0006\u0002\u0002\u0000A1\u00111CA\u000b\u0003\u0003\u00032AUAB\u0013\r\t)i\u0012\u0002\u000f'\u0016\u001c8/[8o\u0019&l\u0017\u000e^3s\u0003-a\u0017.\\5uKJ|F%Z9\u0015\t\u0005-\u00121\u0012\u0005\n\u0003g\u0019\u0012\u0011!a\u0001\u0003\u007f\n\u0001\u0002\\5nSR,'\u000fI\u0001\rE\u0006$8\r\u001b'j[&$XM]\u0001\u0011E\u0006$8\r\u001b'j[&$XM]0%KF$B!a\u000b\u0002\u0016\"I\u00111\u0007\f\u0002\u0002\u0003\u0007\u0011qP\u0001\u000eE\u0006$8\r\u001b'j[&$XM\u001d\u0011\u0016\u0005\u0005m\u0005\u0003CA\n\u0003;\u000b\t+!-\n\u0007\u0005}EL\u0001\u0004UkBdWM\r\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003!\u0019XmY;sSRL(BAAV\u0003\u0011Q\u0017M^1\n\t\u0005=\u0016Q\u0015\u0002\u000b!JLg/\u0019;f\u0017\u0016L\b\u0003BAR\u0003gKA!!.\u0002&\nI\u0001+\u001e2mS\u000e\\U-_\u0001\u0012g&<g.\u001b8h!JLg/\u0019;f\u0017\u0016LXCAAQ\u0003A\u0019\u0018n\u001a8j]\u001e\u0004VO\u00197jG.+\u00170\u0006\u0002\u00022\u0006iRM\\4j]\u0016\u001cF/\u0019:ukB\u0004&o\\2fgN\u001cV-\\1qQ>\u0014X-\u0006\u0002\u0002DB1\u00111CA\u000b\u0003\u000b\u0004B!a2\u0002R6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\fi-\u0001\u0006d_:\u001cWO\u001d:f]RTA!a4\u0002*\u0006!Q\u000f^5m\u0013\u0011\t\u0019.!3\u0003\u0013M+W.\u00199i_J,\u0017!I3oO&tWm\u0015;beR,\b\u000f\u0015:pG\u0016\u001c8oU3nCBDwN]3`I\u0015\fH\u0003BA\u0016\u00033D\u0011\"a\r\u001d\u0003\u0003\u0005\r!a1\u0002=\u0015tw-\u001b8f'R\f'\u000f^;q!J|7-Z:t'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013\u0001H3oO&tWmQ8o]\u0016\u001cG/[8o\u00032Lg/Z\"iK\u000e\\WM]\u000b\u0003\u0003C\u0004B!a2\u0002d&!\u0011Q]Ae\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u001eK:<\u0017N\\3D_:tWm\u0019;j_:\fE.\u001b<f\u0007\",7m[3sA\u0005yA/Z7q\r&dWmU3sm&\u001cW-\u0006\u0002\u0002nB!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t&\u000bqa]3sm&\u001cW-\u0003\u0003\u0002x\u0006E(a\u0004+f[B4\u0015\u000e\\3TKJ4\u0018nY3\u0002!Q,W\u000e\u001d$jY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013AC5oSRL\u0017\r\\5{KR!\u00111FA\u0000\u0011\u001d\u0011\tA\ta\u0001\u0005\u0007\tAaY8oMB!!Q\u0001B\u0006\u001b\t\u00119AC\u0002\u0003\n%\u000baaY8oM&<\u0017\u0002\u0002B\u0007\u0005\u000f\u0011!bS=vk\nL7i\u001c8g\u00035\u0019'/Z1uKN+7o]5p]Ra!1\u0003B\r\u0005o\u0011YDa\u0010\u0003DA\u0019!K!\u0006\n\u0007\t]qIA\u0004TKN\u001c\u0018n\u001c8\t\u000f\tm1\u00051\u0001\u0003\u001e\u0005A\u0001O]8u_\u000e|G\u000e\u0005\u0003\u0003 \tMRB\u0001B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\rQD'/\u001b4u\u0015\u0011\u00119C!\u000b\u0002\u0007I\u00048M\u0003\u0003\u0002t\n-\"\u0002\u0002B\u0017\u0005_\tA\u0001[5wK*\u0019!\u0011G%\u0002\rMD\u0017\rZ3e\u0013\u0011\u0011)D!\t\u0003!Q\u0003&o\u001c;pG>dg+\u001a:tS>t\u0007B\u0002B\u001dG\u0001\u0007a+\u0001\u0003vg\u0016\u0014\bB\u0002B\u001fG\u0001\u0007a+\u0001\u0005qCN\u001cxo\u001c:e\u0011\u0019\u0011\te\ta\u0001-\u0006I\u0011\u000e]!eIJ,7o\u001d\u0005\b\u0005\u0003\u0019\u0003\u0019\u0001B#!\u00159&q\t,W\u0013\r\u0011IE\u0019\u0002\u0004\u001b\u0006\u0004\u0018aC8qK:\u001cVm]:j_:$BBa\u0014\u0003V\t]#\u0011\fB.\u0005;\u00022A\u0015B)\u0013\r\u0011\u0019f\u0012\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\u000f\tmA\u00051\u0001\u0003\u001e!1!\u0011\b\u0013A\u0002YCaA!\u0010%\u0001\u00041\u0006B\u0002B!I\u0001\u0007a\u000bC\u0004\u0003\u0002\u0011\u0002\rA!\u0012\u0002\u0019\rdwn]3TKN\u001c\u0018n\u001c8\u0015\t\u0005-\"1\r\u0005\b\u0005K*\u0003\u0019\u0001B(\u00035\u0019Xm]:j_:D\u0015M\u001c3mK\u0006\u00112M]3bi\u0016\u0014\u0015\r^2i'\u0016\u001c8/[8o)a\u0011YG!\u001d\u0003t\tU$q\u000fB=\u0005{\u0012\u0019Ia\"\u0003\f\nE%\u0011\u0015\t\u0004%\n5\u0014b\u0001B8\u000f\n\u00112*_;vE&\u0014\u0015\r^2i'\u0016\u001c8/[8o\u0011\u0019\u0011ID\na\u0001-\"1!Q\b\u0014A\u0002YCaA!\u0011'\u0001\u00041\u0006b\u0002B\u0001M\u0001\u0007!Q\t\u0005\u0007\u0005w2\u0003\u0019\u0001,\u0002\u0013\t\fGo\u00195UsB,\u0007b\u0002B@M\u0001\u0007!\u0011Q\u0001\nE\u0006$8\r\u001b(b[\u0016\u0004R!a\u0005\u0002\u0016YCaA!\"'\u0001\u00041\u0016\u0001\u0003:fg>,(oY3\t\r\t%e\u00051\u0001W\u0003%\u0019G.Y:t\u001d\u0006lW\rC\u0004\u0003\u000e\u001a\u0002\rAa$\u0002\u0013\t\fGo\u00195Be\u001e\u001c\b#BA+\u0003?2\u0006\"CA\u0010MA\u0005\t\u0019\u0001BJ!\u0019\t\u0019\"!\u0006\u0003\u0016B!!q\u0013BO\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\u0006u\u0011aA1qS&!!q\u0014BM\u0005!iU\r^1eCR\f\u0007b\u0002BRM\u0001\u0007!QU\u0001\rMJ|WNU3d_Z,'/\u001f\t\u0005\u0003'\u00119+C\u0002\u0003*r\u0013qAQ8pY\u0016\fg.A\u000fde\u0016\fG/\u001a\"bi\u000eD7+Z:tS>tG\u0005Z3gCVdG\u000fJ\u00191+\t\u0011yK\u000b\u0003\u0003\u0014\nE6F\u0001BZ!\u0011\u0011)La0\u000e\u0005\t]&\u0002\u0002B]\u0005w\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tuF,\u0001\u0006b]:|G/\u0019;j_:LAA!1\u00038\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!=\u0004XM\u001c\"bi\u000eD7+Z:tS>tG\u0003\u0002B(\u0005\u000fDqA!3)\u0001\u0004\u0011Y'\u0001\u0007cCR\u001c\u0007nU3tg&|g\u000e\u0006\u0006\u0003P\t5'q\u001aBi\u0005'DaA!\u000f*\u0001\u00041\u0006B\u0002B\u001fS\u0001\u0007a\u000b\u0003\u0004\u0003B%\u0002\rA\u0016\u0005\b\u0005+L\u0003\u0019\u0001Bl\u00031\u0011\u0017\r^2i%\u0016\fX/Z:u!\u0011\u0011IN!;\u000e\u0005\tm'\u0002\u0002Bo\u0005?\f1\u0001\u001a;p\u0015\u0011\u0011\tOa9\u0002\u0005Y\f$\u0002\u0002BN\u0005KT1Aa:J\u0003\u0019\u0019G.[3oi&!!1\u001eBn\u00051\u0011\u0015\r^2i%\u0016\fX/Z:u\u0003QIg.\u001b;jC2L'0\u001a\"bi\u000eD7\u000b^1uKRIaK!=\u0003t\nU(q\u001f\u0005\u0007\u0005sQ\u0003\u0019\u0001,\t\r\t\u0005#\u00061\u0001W\u0011\u001d\u0011\tA\u000ba\u0001\u0005\u000bBqA!6+\u0001\u0004\u00119.A\bhKR\u0014\u0015\r^2i'\u0016\u001c8/[8o)\u0011\u0011iPa@\u0011\r\u0005M\u0011Q\u0003B6\u0011\u001d\u0011)g\u000ba\u0001\u0005\u001f\na\"\u001b8tKJ$X*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002,\r\u0015\u0001bBA\u0010Y\u0001\u0007!QS\u0001\u000fkB$\u0017\r^3NKR\fG-\u0019;b)\u0011\tYca\u0003\t\u000f\u0005}Q\u00061\u0001\u0003\u0016\u0006Yr-\u001a;NKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001a$Ba!\u0005\u0004\u001aA1\u00111CA\u000b\u0007'\u0001B!a\u0007\u0004\u0016%!1qCA\u000f\u0005aiU\r^1eCR\f'+Z9vKN$8OU3uef\u0014VM\u001a\u0005\u0007\u00077q\u0003\u0019\u0001,\u0002\u0015%$WM\u001c;jM&,'/\u0001\u0012eKJ+w-[:uKJlU\r^1eCR\f'+Z9vKN$8OU3uef\u0014VM\u001a\u000b\u0005\u0003W\u0019\t\u0003\u0003\u0004\u0004\u001c=\u0002\rAV\u0001\u001aO\u0016$()\u0019;dQ\u001a\u0013x.\\'fi\u0006$\u0017\r^1Ti>\u0014X\r\u0006\u0003\u0004(\r=\u0002CBA\n\u0003+\u0019I\u0003\u0005\u0003\u0003Z\u000e-\u0012\u0002BB\u0017\u00057\u0014QAQ1uG\"Daa!\r1\u0001\u00041\u0016a\u00022bi\u000eD\u0017\nZ\u0001\u001cO\u0016$()\u0019;dQ\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uCN#xN]3\u0015\u0015\r]2\u0011HB\"\u0007\u001b\u001a\t\u0006\u0005\u0004\u0002V\u0005}3\u0011\u0006\u0005\b\u0007w\t\u0004\u0019AB\u001f\u0003\u00191\u0017\u000e\u001c;feB!!qSB \u0013\u0011\u0019\tE!'\u0003\u001d5+G/\u00193bi\u00064\u0015\u000e\u001c;fe\"91QI\u0019A\u0002\r\u001d\u0013\u0001\u00024s_6\u0004B!a\u0005\u0004J%\u001911\n/\u0003\u0007%sG\u000fC\u0004\u0004PE\u0002\raa\u0012\u0002\tML'0\u001a\u0005\n\u0007'\n\u0004\u0013!a\u0001\u0005K\u000bA\u0001Z3tG\u0006)s-\u001a;CCR\u001c\u0007.Z:Ge>lW*\u001a;bI\u0006$\u0018m\u0015;pe\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u00073RCA!*\u00032\u0006\u0001r-\u001a;CCR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0005\u0005'\u001by\u0006\u0003\u0004\u00042M\u0002\rAV\u0001\u0010G2,\u0017M\\;q\u001b\u0016$\u0018\rZ1uCR!\u00111FB3\u0011\u0019\u0019Y\u0002\u000ea\u0001-\"\u001aAg!\u001b\u0011\t\r-4QP\u0007\u0003\u0007[RAaa\u001c\u0004r\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\u0019\u0019h!\u001e\u0002\r\r|W.\\8o\u0015\u0011\u00199h!\u001f\u0002\r\u001d|wn\u001a7f\u0015\t\u0019Y(A\u0002d_6LAaa \u0004n\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005-\u0012!G4fi\n\u000bGo\u00195TKN\u001c\u0018n\u001c8t)>\u0014VmY8wKJ$Ba!#\u0004\fB1\u0011QKA0\u0005WBaa!$7\u0001\u00041\u0016AD6zkV\u0014\u0017.\u00138ti\u0006t7-Z\u0001\"O\u0016$8\u000b]3dS\u001aL7MQ1uG\"\u001cVm]:j_:\u001cHk\u001c*fG>4XM\u001d\u000b\u0007\u0007\u0013\u001b\u0019ja&\t\u000f\rUu\u00071\u0001\u0003\u0010\u0006A!-\u0019;dQ&#7\u000f\u0003\u0004\u0004\u000e^\u0002\rAV\u0001\u001fGJ,\u0017\r^3CCR\u001c\u0007nU3tg&|gN\u0012:p[J+7m\u001c<fef$BAa\u001b\u0004\u001e\"9\u0011q\u0004\u001dA\u0002\tU\u0015!\u0006:fCN\u001c\u0018n\u001a8CCR\u001c\u0007nU3tg&|gn\u001d\u000b\u0007\u0005\u001f\u001b\u0019k!*\t\r\r5\u0015\b1\u0001W\u0011\u0019\u00199+\u000fa\u0001-\u0006\tb.Z<LsV,(-[%ogR\fgnY3\u0002E\u001d,G\u000fU3fe&s7\u000f^1oG\u0016\u001cEn\\:fI\n\u000bGo\u00195TKN\u001c\u0018n\u001c8t)\u0011\u0019ika,\u0011\r\u0005U\u0013q\fBK\u0011\u0019\u0019iI\u000fa\u0001-\u0006A\u0011n]*feZ,'/\u0006\u0002\u0003&\u0006\u0011\u0012N\\5u'\u0016\u001c8/[8o\u0019&l\u0017\u000e^3s)\u0011\tYc!/\t\u000f\t\u0005A\b1\u0001\u0003\u0004\u0005\tr-\u001a;V]2LW.\u001b;fIV\u001bXM]:\u0016\u0005\r}\u0006\u0003B,\u0004BZK1aa1c\u0005\r\u0019V\r^\u0001\u0016e\u00164'/Z:i+:d\u0017.\\5uK\u0012,6/\u001a:t)\u0011\tYc!3\t\u000f\t\u0005a\b1\u0001\u0003\u0004\u0005aq-\u001a;EK:LXk]3sg\u0006\u0001\"/\u001a4sKNDG)\u001a8z+N,'o\u001d\u000b\u0005\u0003W\u0019\t\u000eC\u0004\u0003\u0002\u0001\u0003\rAa\u0001\u0002\u0015\u001d,G\u000fR3os&\u00038/\u0001\bsK\u001a\u0014Xm\u001d5EK:L\u0018\n]:\u0015\t\u0005-2\u0011\u001c\u0005\b\u0005\u0003\u0011\u0005\u0019\u0001B\u0002\u0003M\t\u0007\u000f\u001d7z'\u0016\u001c8/[8o\u0019&l\u0017\u000e^3s)9\tyha8\u0004d\u000e\u001d81^Bx\u0007gDqa!9D\u0001\u0004\u00199%A\u0005vg\u0016\u0014H*[7ji\"91Q]\"A\u0002\r\u001d\u0013AD5q\u0003\u0012$'/Z:t\u0019&l\u0017\u000e\u001e\u0005\b\u0007S\u001c\u0005\u0019AB$\u0003I)8/\u001a:Ja\u0006#GM]3tg2KW.\u001b;\t\u000f\r58\t1\u0001\u0004@\u0006\tRo]3s+:d\u0017.\\5uK\u0012d\u0015n\u001d;\t\u000f\rE8\t1\u0001\u0004@\u0006aQo]3s\t\u0016t\u0017\u0010T5ti\"91Q_\"A\u0002\r}\u0016AC5q\t\u0016t\u0017\u0010T5ti\u000692\u000f^1si\u0016sw-\u001b8f\u00032Lg/Z\"iK\u000e\\WM]\u0001\"S:LG/\u00128hS:,7\u000b^1siV\u0004\bK]8dKN\u001c8+Z7ba\"|'/\u001a\u000b\u0005\u0003W\u0019i\u0010C\u0004\u0003\u0002\u0015\u0003\rAa\u0001")
public class KyuubiSessionManager
extends SessionManager {
    private Seq<SessionConfAdvisor> sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private Option<MetadataManager> metadataManager = None$.MODULE$;
    private KyuubiApplicationManager applicationManager;
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private final TempFileService tempFileService;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public Option<MetadataManager> metadataManager() {
        return this.metadataManager;
    }

    public void metadataManager_$eq(Option<MetadataManager> x$1) {
        this.metadataManager = x$1;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    public void applicationManager_$eq(KyuubiApplicationManager x$1) {
        this.applicationManager = x$1;
    }

    private Seq<SessionConfAdvisor> sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sessionConfAdvisor;
    }

    public Seq<SessionConfAdvisor> sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public TempFileService tempFileService() {
        return this.tempFileService;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        if (conf.isRESTEnabled()) {
            this.metadataManager_$eq((Option<MetadataManager>)new Some((Object)new MetadataManager()));
        }
        this.applicationManager_$eq(new KyuubiApplicationManager(this.metadataManager()));
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.addService((Service)this.tempFileService());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        KyuubiConf userConf = this.getConf().getUserDefaults(user);
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, userConf, BoxesRunTime.unboxToBoolean((Object)userConf.get(KyuubiConf$.MODULE$.ENGINE_DO_AS_ENABLED())), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            this.setSession(handle, (Session)batchSession);
            batchSession.open();
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)"kyuubi.batch.id");
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size, boolean desc) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size, desc)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public boolean getBatchesFromMetadataStore$default$4() {
        return false;
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSessionFromRecovery((Metadata)metadata), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<KyuubiBatchSession> getSpecificBatchSessionsToRecover(Seq<String> batchIds, String kyuubiInstance) {
        Set batchStatesToRecovery = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{OperationState$.MODULE$.PENDING(), OperationState$.MODULE$.RUNNING()}));
        return (Seq)batchIds.flatMap((Function1 & Serializable & scala.Serializable)batchId -> {
            Option<KyuubiBatchSession> option = this.getBatchSession(SessionHandle$.MODULE$.fromUUID(batchId));
            if (option instanceof Some) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Batch session ").append((String)batchId).append(" is already active, skipping recovery.").toString());
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            if (None$.MODULE$.equals(option)) {
                return Option$.MODULE$.option2Iterable(this.getBatchMetadata((String)batchId).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$getSpecificBatchSessionsToRecover$3(kyuubiInstance, batchStatesToRecovery, m))).flatMap((Function1 & Serializable & scala.Serializable)metadata -> new Some((Object)this.createBatchSessionFromRecovery((Metadata)metadata))));
            }
            throw new MatchError(option);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private KyuubiBatchSession createBatchSessionFromRecovery(Metadata metadata) {
        return this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some((Object)metadata), true);
    }

    public Seq<String> reassignBatchSessions(String kyuubiInstance, String newKyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> (Seq)x$19.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> {
            String x$1 = metadata.identifier();
            String x$2 = newKyuubiInstance;
            Enumeration.Value x$3 = Metadata$.MODULE$.apply$default$2();
            String x$4 = Metadata$.MODULE$.apply$default$3();
            String x$5 = Metadata$.MODULE$.apply$default$4();
            String x$6 = Metadata$.MODULE$.apply$default$5();
            String x$7 = Metadata$.MODULE$.apply$default$7();
            String x$8 = Metadata$.MODULE$.apply$default$8();
            String x$9 = Metadata$.MODULE$.apply$default$9();
            String x$10 = Metadata$.MODULE$.apply$default$10();
            Map<String, String> x$11 = Metadata$.MODULE$.apply$default$11();
            Seq<String> x$12 = Metadata$.MODULE$.apply$default$12();
            long x$13 = Metadata$.MODULE$.apply$default$13();
            String x$14 = Metadata$.MODULE$.apply$default$14();
            Option<String> x$15 = Metadata$.MODULE$.apply$default$15();
            long x$16 = Metadata$.MODULE$.apply$default$16();
            String x$17 = Metadata$.MODULE$.apply$default$17();
            String x$18 = Metadata$.MODULE$.apply$default$18();
            String x$19 = Metadata$.MODULE$.apply$default$19();
            String x$20 = Metadata$.MODULE$.apply$default$20();
            Option<String> x$21 = Metadata$.MODULE$.apply$default$21();
            long x$22 = Metadata$.MODULE$.apply$default$22();
            int x$23 = Metadata$.MODULE$.apply$default$23();
            boolean x$24 = Metadata$.MODULE$.apply$default$24();
            this.updateMetadata(new Metadata(x$1, x$3, x$4, x$5, x$6, x$2, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24));
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Reassign batch ").append(metadata.identifier()).append(" from ").append(kyuubiInstance).append(" to ").append(newKyuubiInstance).toString());
            return metadata.identifier();
        }, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$21)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$22)));
        Set ipDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$6(x$23)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$24)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$25, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$26 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$26, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$27)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$28, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$29 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$29, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyIps() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyIps((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyIps(KyuubiConf conf) {
        Set denyIps = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyIps$1(x$30)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$31, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$32 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$32, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList, Set<String> ipDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$33 -> x$33 > 0) || userDenyList.nonEmpty() || ipDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList, ipDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.engineConnectionAliveChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$34 -> x$34 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$6(MetricsSystem ms$1, Semaphore semaphore) {
        ms$1.markMeter(MetricsConstants$.MODULE$.ENGINE_STARTUP_PERMIT_LIMIT(), (long)semaphore.availablePermits());
        ms$1.registerGauge(MetricsConstants$.MODULE$.ENGINE_STARTUP_PERMIT_AVAILABLE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> semaphore.availablePermits(), (Object)BoxesRunTime.boxToInteger((int)semaphore.availablePermits()));
        ms$1.registerGauge(MetricsConstants$.MODULE$.ENGINE_STARTUP_PERMIT_WAITING(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> semaphore.getQueueLength(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveUserSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        $this.engineStartupProcessSemaphore().foreach((Function1 & Serializable & scala.Serializable)semaphore -> {
            KyuubiSessionManager.$anonfun$start$6(ms, semaphore);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSpecificBatchSessionsToRecover$3(String kyuubiInstance$2, Set batchStatesToRecovery$1, Metadata m) {
        String string = m.kyuubiInstance();
        String string2 = kyuubiInstance$2;
        return !(string != null ? !string.equals(string2) : string2 != null) && batchStatesToRecovery$1.contains((Object)m.opState());
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$6(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$24) {
        return new StringOps(Predef$.MODULE$.augmentString(x$24)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$27) {
        return new StringOps(Predef$.MODULE$.augmentString(x$27)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyIps$1(String x$30) {
        return new StringOps(Predef$.MODULE$.augmentString(x$30)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiSessionImpl) {
            BoxedUnit boxedUnit;
            KyuubiSessionImpl kyuubiSessionImpl = (KyuubiSessionImpl)session;
            try {
                if (!kyuubiSessionImpl.checkEngineConnectionAlive()) {
                    $this.closeSession(kyuubiSessionImpl.handle());
                    $this.logger().info(new StringBuilder(98).append("The session ").append(kyuubiSessionImpl.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(kyuubiSessionImpl.handle()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.tempFileService = new TempFileService();
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

