/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.kyuubi.client.api.v1.dto.Batch;

public final class BatchUtils {
    public static String PENDING_STATE = "PENDING";
    public static String RUNNING_STATE = "RUNNING";
    public static String FINISHED_STATE = "FINISHED";
    public static String ERROR_STATE = "ERROR";
    public static String CANCELED_STATE = "CANCELED";
    public static List<String> terminalBatchStates = Arrays.asList(FINISHED_STATE, ERROR_STATE, CANCELED_STATE);
    public static String KYUUBI_BATCH_ID_KEY = "kyuubi.batch.id";
    public static String KYUUBI_BATCH_DUPLICATED_KEY = "kyuubi.batch.duplicated";

    public static boolean isPendingState(String state) {
        return PENDING_STATE.equalsIgnoreCase(state);
    }

    public static boolean isRunningState(String state) {
        return RUNNING_STATE.equalsIgnoreCase(state);
    }

    public static boolean isFinishedState(String state) {
        return FINISHED_STATE.equalsIgnoreCase(state);
    }

    public static boolean isTerminalState(String state) {
        return state != null && terminalBatchStates.contains(state.toUpperCase(Locale.ROOT));
    }

    public static boolean isDuplicatedSubmission(Batch batch) {
        return "true".equalsIgnoreCase(batch.getBatchInfo().get(KYUUBI_BATCH_DUPLICATED_KEY));
    }
}

