/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.stub;

import io.grpc.stub.StreamObserver;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;

public class GrpcWriteStream<T>
implements WriteStream<T> {
    private final StreamObserver<T> observer;
    private Handler<Throwable> errHandler;

    public GrpcWriteStream(StreamObserver<T> observer) {
        this.observer = observer;
        this.errHandler = arg_0 -> observer.onError(arg_0);
    }

    public WriteStream<T> exceptionHandler(Handler<Throwable> hndlr) {
        this.errHandler = hndlr == null ? arg_0 -> this.observer.onError(arg_0) : t -> {
            this.observer.onError(t);
            hndlr.handle(t);
        };
        return this;
    }

    public Future<Void> write(T data) {
        try {
            this.observer.onNext(data);
        }
        catch (Throwable e) {
            return Future.failedFuture((Throwable)e);
        }
        return Future.succeededFuture();
    }

    public void write(T data, Handler<AsyncResult<Void>> hndlr) {
        try {
            this.observer.onNext(data);
        }
        catch (Throwable e) {
            hndlr.handle((Object)Future.failedFuture((Throwable)e));
            return;
        }
        hndlr.handle((Object)Future.succeededFuture());
    }

    public void end(Handler<AsyncResult<Void>> hndlr) {
        try {
            this.observer.onCompleted();
        }
        catch (Throwable e) {
            hndlr.handle((Object)Future.failedFuture((Throwable)e));
            return;
        }
        hndlr.handle((Object)Future.succeededFuture());
    }

    public WriteStream<T> setWriteQueueMaxSize(int i) {
        this.errHandler.handle((Object)new UnsupportedOperationException());
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    public WriteStream<T> drainHandler(Handler<Void> hndlr) {
        this.errHandler.handle((Object)new UnsupportedOperationException());
        return this;
    }

    public StreamObserver<T> streamObserver() {
        return this.observer;
    }
}

