/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl.future;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.kyuubi.shade.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.kyuubi.shade.io.netty.util.concurrent.OrderedEventExecutor;
import org.apache.kyuubi.shade.io.netty.util.concurrent.ScheduledFuture;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.NoStackTraceTimeoutException;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Composition;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Eventually;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.FixedMapping;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.FixedOtherwise;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.FutureInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Listener;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Mapping;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Otherwise;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Transformation;

abstract class FutureBase<T>
implements FutureInternal<T> {
    protected final ContextInternal context;

    FutureBase() {
        this(null);
    }

    FutureBase(ContextInternal context) {
        this.context = context;
    }

    @Override
    public final ContextInternal context() {
        return this.context;
    }

    protected final void emitSuccess(T value, Listener<T> listener) {
        if (this.context != null && !this.context.isRunningOnContext()) {
            this.context.execute(() -> {
                ContextInternal prev = this.context.beginDispatch();
                try {
                    listener.onSuccess(value);
                }
                finally {
                    this.context.endDispatch(prev);
                }
            });
        } else {
            listener.onSuccess(value);
        }
    }

    protected final void emitFailure(Throwable cause, Listener<T> listener) {
        if (this.context != null && !this.context.isRunningOnContext()) {
            this.context.execute(() -> {
                ContextInternal prev = this.context.beginDispatch();
                try {
                    listener.onFailure(cause);
                }
                finally {
                    this.context.endDispatch(prev);
                }
            });
        } else {
            listener.onFailure(cause);
        }
    }

    @Override
    public <U> Future<U> compose(Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        Objects.requireNonNull(successMapper, "No null success mapper accepted");
        Objects.requireNonNull(failureMapper, "No null failure mapper accepted");
        Composition<T, U> operation = new Composition<T, U>(this.context, successMapper, failureMapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <U> Future<U> transform(Function<AsyncResult<T>, Future<U>> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Transformation<T, U> operation = new Transformation<T, U>(this.context, this, mapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <U> Future<T> eventually(Function<Void, Future<U>> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Eventually operation = new Eventually(this.context, mapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <U> Future<U> map(Function<T, U> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Mapping<T, U> operation = new Mapping<T, U>(this.context, mapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <V> Future<V> map(V value) {
        FixedMapping transformation = new FixedMapping(this.context, value);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Otherwise<T> transformation = new Otherwise<T>(this.context, mapper);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public Future<T> otherwise(T value) {
        FixedOtherwise<T> operation = new FixedOtherwise<T>(this.context, value);
        this.addListener(operation);
        return operation;
    }

    @Override
    public Future<T> timeout(long delay, TimeUnit unit) {
        Promise promise;
        OrderedEventExecutor instance;
        if (this.isComplete()) {
            return this;
        }
        if (this.context != null) {
            instance = this.context.nettyEventLoop();
            promise = this.context.promise();
        } else {
            instance = GlobalEventExecutor.INSTANCE;
            promise = Promise.promise();
        }
        final ScheduledFuture<?> task = instance.schedule(() -> {
            String msg = "Timeout " + unit.toMillis(delay) + " (ms) fired";
            promise.fail(new NoStackTraceTimeoutException(msg));
        }, delay, unit);
        this.addListener(new Listener<T>(){

            @Override
            public void onSuccess(T value) {
                if (task.cancel(false)) {
                    promise.complete(value);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (task.cancel(false)) {
                    promise.fail(failure);
                }
            }
        });
        return promise.future();
    }
}

