/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KyuubiApplicationManager$ {
    public static KyuubiApplicationManager$ MODULE$;
    private final Path uploadWorkDir;

    static {
        new KyuubiApplicationManager$();
    }

    private void setupSparkYarnTag(String tag, KyuubiConf conf) {
        String originalTag = (String)conf.getOption("spark.yarn.tags").map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(1).append((String)x$4).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String newTag = new StringBuilder(6).append(originalTag).append("KYUUBI").append(new Some((Object)tag).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(1).append(",").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        conf.set("spark.yarn.tags", newTag);
    }

    private void setupEngineYarnModeTag(String tag, KyuubiConf conf) {
        String originalTag = (String)conf.getOption(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_TAGS().key()).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(1).append((String)x$7).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String newTag = new StringBuilder(6).append(originalTag).append("KYUUBI").append(new Some((Object)tag).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(1).append(",").append((String)x$9).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        conf.set(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_TAGS().key(), newTag);
    }

    private void setupSparkK8sTag(String tag, KyuubiConf conf) {
        conf.set(new StringBuilder(30).append("spark.kubernetes.driver.label.").append(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY()).toString(), tag);
    }

    private void setupFlinkYarnTag(String tag, KyuubiConf conf) {
        String originalTag = (String)conf.getOption(new StringBuilder(15).append("flink").append(".").append("yarn.tags").toString()).orElse((Function0 & Serializable & scala.Serializable)() -> conf.getOption("yarn.tags")).map((Function1 & Serializable & scala.Serializable)x$10 -> new StringBuilder(1).append((String)x$10).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String newTag = new StringBuilder(6).append(originalTag).append("KYUUBI").append(new Some((Object)tag).filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$12 -> new StringBuilder(1).append(",").append((String)x$12).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        conf.set("yarn.tags", newTag);
    }

    public Path uploadWorkDir() {
        return this.uploadWorkDir;
    }

    public void checkApplicationAccessPath(String path, KyuubiConf conf) {
        block7: {
            block9: {
                URI uri;
                Set localDirAllowList;
                block8: {
                    URI uRI;
                    localDirAllowList = (Set)conf.get(KyuubiConf$.MODULE$.SESSION_LOCAL_DIR_ALLOW_LIST());
                    if (!localDirAllowList.nonEmpty()) break block7;
                    localDirAllowList = (Set)localDirAllowList.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.uploadWorkDir().toUri().getPath()})));
                    try {
                        uRI = new URI(path);
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(e);
                    }
                    uri = uRI;
                    if (uri.getScheme() == null) break block8;
                    String string = uri.getScheme();
                    String string2 = "file";
                    if (string != null ? !string.equals(string2) : string2 != null) break block9;
                }
                if (!uri.getPath().startsWith(File.separator)) {
                    throw new KyuubiException(new StringBuilder(56).append("Relative path ").append(uri.getPath()).append(" is not allowed, please use absolute path.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
                if (!localDirAllowList.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)KyuubiApplicationManager$.$anonfun$checkApplicationAccessPath$1(uri, x$13)))) {
                    throw new KyuubiException(new StringBuilder(58).append("The file ").append(uri.getPath()).append(" to access is not in the local dir allow list").append(" [").append(localDirAllowList.mkString(",")).append("].").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
                return;
            }
            return;
        }
    }

    private void checkSparkAccessPaths(Map<String, String> appConf, KyuubiConf kyuubiConf) {
        if (((TraversableOnce)kyuubiConf.get(KyuubiConf$.MODULE$.SESSION_LOCAL_DIR_ALLOW_LIST())).nonEmpty()) {
            ((IterableLike)((TraversableLike)SparkProcessBuilder$.MODULE$.PATH_CONFIGS().flatMap((Function1 & Serializable & scala.Serializable)key -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appConf.get((Object)key).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.split(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))))), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)KyuubiApplicationManager$.$anonfun$checkSparkAccessPaths$4(x$15)))).foreach((Function1 & Serializable & scala.Serializable)path -> {
                KyuubiApplicationManager$.MODULE$.checkApplicationAccessPath(path, kyuubiConf);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void tagApplication(String applicationTag, String applicationType, Option<String> resourceManager, KyuubiConf conf) {
        String string;
        Tuple2 tuple2 = new Tuple2((Object)applicationType.toUpperCase(), (Object)resourceManager.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toUpperCase()));
        if (tuple2 != null) {
            Some some;
            String string2;
            String string3 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("SPARK".equals(string3) && option instanceof Some && "YARN".equals(string2 = (String)(some = (Some)option).value())) {
                this.setupSparkYarnTag(applicationTag, conf);
                return;
            }
        }
        if (tuple2 != null) {
            Some some;
            String rm;
            String string4 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("SPARK".equals(string4) && option instanceof Some && (rm = (String)(some = (Some)option).value()).startsWith("K8S")) {
                this.setupSparkK8sTag(applicationTag, conf);
                return;
            }
        }
        if (tuple2 != null && "SPARK".equals(string = (String)tuple2._1())) {
            this.setupSparkYarnTag(applicationTag, conf);
            this.setupSparkK8sTag(applicationTag, conf);
            return;
        }
        if (tuple2 != null) {
            Some some;
            String string5;
            String string6 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("FLINK".equals(string6) && option instanceof Some && "YARN".equals(string5 = (String)(some = (Some)option).value())) {
                this.setupFlinkYarnTag(applicationTag, conf);
                return;
            }
        }
        if (tuple2 != null) {
            Some some;
            String string7;
            String string8 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("HIVE".equals(string8) && option instanceof Some && "YARN".equals(string7 = (String)(some = (Some)option).value())) {
                this.setupEngineYarnModeTag(applicationTag, conf);
                return;
            }
        }
        if (tuple2 != null) {
            Some some;
            String string9;
            String string10 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("JDBC".equals(string10) && option instanceof Some && "YARN".equals(string9 = (String)(some = (Some)option).value())) {
                this.setupEngineYarnModeTag(applicationTag, conf);
                return;
            }
        }
    }

    public void checkApplicationAccessPaths(String applicationType, Map<String, String> appConf, KyuubiConf kyuubiConf) {
        String string = applicationType.toUpperCase(Locale.ROOT);
        if (string.contains("SPARK")) {
            this.checkSparkAccessPaths(appConf, kyuubiConf);
            return;
        }
        if (string.startsWith("FLINK")) {
            return;
        }
    }

    public Path sessionUploadFolderPath(String sessionId) {
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)sessionId));
        return this.uploadWorkDir().resolve(sessionId);
    }

    public static final /* synthetic */ boolean $anonfun$checkApplicationAccessPath$1(URI uri$1, String x$13) {
        return uri$1.getPath().startsWith(x$13);
    }

    public static final /* synthetic */ boolean $anonfun$checkSparkAccessPaths$4(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private KyuubiApplicationManager$() {
        void var1_1;
        MODULE$ = this;
        Path path = Utils$.MODULE$.getAbsolutePathFromWork("upload", Utils$.MODULE$.getAbsolutePathFromWork$default$2());
        File pathFile = path.toFile();
        Object object = !pathFile.exists() ? Files.createDirectories(path, new FileAttribute[0]) : BoxedUnit.UNIT;
        this.uploadWorkDir = var1_1;
    }
}

