/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.query;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.query.ProbabilityGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbabilityGeneratorCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(ProbabilityGeneratorCLI.class);
    private static final Option OPTION_SIZE;
    private static final Option OPTION_OUTPUT;
    protected final Options options = new Options();
    private int size;
    private String outputPath;

    public ProbabilityGeneratorCLI() {
        this.options.addOption(OPTION_SIZE);
        this.options.addOption(OPTION_OUTPUT);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.size = Integer.parseInt(optionsHelper.getOptionValue(OPTION_SIZE));
        this.outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT);
        this.run();
    }

    public double[] execute(int sizeOfQueryList, String outputPath) throws Exception {
        this.size = sizeOfQueryList;
        this.outputPath = outputPath;
        return this.run();
    }

    private double[] run() throws Exception {
        double[] probArray = ProbabilityGenerator.generateProbabilityList(this.size);
        ProbabilityGeneratorCLI.storeProbability(probArray, this.outputPath);
        return ProbabilityGenerator.generateProbabilityCumulative(probArray);
    }

    public double[] execute(int size) throws Exception {
        this.size = size;
        double[] pQueryArray = ProbabilityGenerator.generateProbabilityList(this.size);
        return ProbabilityGenerator.generateProbabilityCumulative(pQueryArray);
    }

    public static void storeProbability(double[] probArray, String outputPath) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath + ".prob"), StandardCharsets.UTF_8));){
            for (double elem : probArray) {
                bufferedWriter.append(String.valueOf(elem));
                bufferedWriter.append("\n");
                logger.info(String.valueOf(elem));
            }
        }
    }

    public static void main(String[] args) {
        ProbabilityGeneratorCLI probabilityGeneratorCLI = new ProbabilityGeneratorCLI();
        probabilityGeneratorCLI.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"size");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the size of query set to be generated");
        OPTION_SIZE = OptionBuilder.create((String)"size");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the output path for generated probability set");
        OPTION_OUTPUT = OptionBuilder.create((String)"output");
    }
}

