/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.GeneralColumnDataWriter;

public class RunLengthCompressedColumnWriter
implements ColumnDataWriter {
    private int valLen;
    private int numValInBlock;
    private int blockCnt;
    private ByteBuffer writeBuffer;
    private DataOutputStream dataOutput;
    private byte[] previousVal;
    private int numOfVals = 1;
    private int blockWriteCnt;
    private int totalWriteCntBeforeTheEntry;
    private int entryNum;
    private List<Integer> entryIndex;
    private GeneralColumnDataWriter blockDataWriter;

    public RunLengthCompressedColumnWriter(int valLen, int rowCnt, int compressBlockSize, OutputStream output) {
        this.valLen = valLen;
        this.numValInBlock = compressBlockSize / valLen;
        this.blockCnt = rowCnt / this.numValInBlock;
        if (rowCnt % this.numValInBlock != 0) {
            ++this.blockCnt;
        }
        this.writeBuffer = ByteBuffer.allocate(this.numValInBlock * (valLen + 8) + 4);
        this.dataOutput = new DataOutputStream(output);
        this.blockDataWriter = new GeneralColumnDataWriter(this.blockCnt, this.dataOutput);
        this.entryIndex = Lists.newArrayListWithCapacity(512);
    }

    @Override
    public void write(byte[] valBytes) throws IOException {
        boolean lastVal;
        ++this.blockWriteCnt;
        boolean bl = lastVal = this.blockWriteCnt == this.numValInBlock;
        if (this.previousVal == null) {
            this.previousVal = valBytes;
            if (lastVal) {
                this.writeEntry(this.numOfVals, this.previousVal);
                this.writeBlockData();
            }
        } else {
            boolean same;
            boolean bl2 = same = Bytes.compareTo(this.previousVal, valBytes) == 0;
            if (same) {
                ++this.numOfVals;
            } else {
                this.writeEntry(this.numOfVals, this.previousVal);
            }
            this.previousVal = valBytes;
            if (lastVal) {
                if (same) {
                    this.writeEntry(this.numOfVals, this.previousVal);
                } else {
                    this.writeEntry(1, valBytes);
                }
                this.writeBlockData();
            }
        }
    }

    private void writeEntry(int numOfVals, byte[] val) {
        this.writeBuffer.putInt(numOfVals);
        this.writeBuffer.put(val);
        this.totalWriteCntBeforeTheEntry += numOfVals;
        this.entryIndex.add(this.totalWriteCntBeforeTheEntry - 1);
        ++this.entryNum;
        this.numOfVals = 1;
    }

    private void writeBlockData() throws IOException {
        this.writeEntriesIndex();
        this.blockDataWriter.write(this.writeBuffer.array(), 0, this.writeBuffer.position());
        this.writeBuffer.rewind();
        this.previousVal = null;
        this.numOfVals = 1;
        this.blockWriteCnt = 0;
        this.totalWriteCntBeforeTheEntry = 0;
        this.entryNum = 0;
        this.entryIndex.clear();
    }

    private void writeEntriesIndex() {
        for (int indexVal : this.entryIndex) {
            this.writeBuffer.putInt(indexVal);
        }
        this.writeBuffer.putInt(this.entryNum);
    }

    @Override
    public void flush() throws IOException {
        if (this.blockWriteCnt > 0) {
            this.writeEntry(this.numOfVals, this.previousVal);
            this.writeBlockData();
        }
        this.blockDataWriter.flush();
        this.dataOutput.writeInt(this.numValInBlock);
        this.dataOutput.writeInt(this.valLen);
        this.dataOutput.flush();
        this.writeBuffer = null;
    }
}

