/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.storage.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingTupleConverter {
    private static final Logger logger = LoggerFactory.getLogger(StreamingTupleConverter.class);
    final TupleInfo tupleInfo;
    final int[] dimTupleIdx;
    final int[] metricsTupleIdx;
    final int dimCnt;
    final int metricsCnt;
    final MeasureType<?>[] measureTypes;
    final Set<Integer> needAdjustTimeColumns = new HashSet<Integer>();
    final List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    final List<Integer> advMeasureIndexInGTValues;
    final boolean autoTimezone = KylinConfig.getInstanceFromEnv().getStreamingDerivedTimeTimezone().length() > 0;
    private static final long TIME_ZONE_OFFSET = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getStreamingDerivedTimeTimezone()).getRawOffset();

    public StreamingTupleConverter(ResponseResultSchema schema, TupleInfo returnTupleInfo) {
        this.tupleInfo = returnTupleInfo;
        this.dimCnt = schema.getDimensionCount();
        this.metricsCnt = schema.getMetricsCount();
        this.dimTupleIdx = new int[this.dimCnt];
        this.metricsTupleIdx = new int[this.metricsCnt];
        this.measureTypes = new MeasureType[this.metricsCnt];
        this.advMeasureFillers = Lists.newArrayListWithCapacity(1);
        this.advMeasureIndexInGTValues = Lists.newArrayListWithCapacity(1);
        int idx = 0;
        for (TblColRef tblColRef : schema.getDimensions()) {
            int n = this.dimTupleIdx[idx] = this.tupleInfo.hasColumn(tblColRef) ? this.tupleInfo.getColumnIndex(tblColRef) : -1;
            if (tblColRef.getType().isDateTimeFamily() && !TimeDerivedColumnType.isTimeDerivedColumnAboveDayLevel(tblColRef.getName())) {
                this.needAdjustTimeColumns.add(this.dimTupleIdx[idx]);
            }
            ++idx;
        }
        idx = 0;
        for (Serializable serializable : schema.getMetrics()) {
            TblColRef col;
            String rewriteFieldName;
            this.metricsTupleIdx[idx] = ((FunctionDesc)serializable).needRewrite() ? (this.tupleInfo.hasField(rewriteFieldName = ((FunctionDesc)serializable).getRewriteFieldName()) ? this.tupleInfo.getFieldIndex(rewriteFieldName) : -1) : (this.tupleInfo.hasColumn(col = ((FunctionDesc)serializable).getParameter().getColRefs().get(0)) ? this.tupleInfo.getColumnIndex(col) : -1);
            MeasureType<?> measureType = ((FunctionDesc)serializable).getMeasureType();
            if (measureType.needAdvancedTupleFilling()) {
                this.advMeasureFillers.add(measureType.getAdvancedTupleFiller((FunctionDesc)serializable, returnTupleInfo, null));
                this.advMeasureIndexInGTValues.add(idx);
            } else {
                this.measureTypes[idx] = measureType;
            }
            ++idx;
        }
    }

    public List<MeasureType.IAdvMeasureFiller> translateResult(Record record, Tuple tuple) {
        int ti;
        int i;
        String[] dimValues = record.getDimensions();
        Object[] metricsValues = record.getMetrics();
        for (i = 0; i < this.dimCnt; ++i) {
            ti = this.dimTupleIdx[i];
            if (ti < 0) continue;
            if (this.autoTimezone && this.needAdjustTimeColumns.contains(ti)) {
                try {
                    tuple.setDimensionValue(ti, Long.toString(Long.parseLong(dimValues[i]) + TIME_ZONE_OFFSET));
                }
                catch (NumberFormatException nfe) {
                    logger.warn("{} is not a long value.", (Object)dimValues[i]);
                    tuple.setDimensionValue(ti, dimValues[i]);
                }
                continue;
            }
            tuple.setDimensionValue(ti, dimValues[i]);
        }
        for (i = 0; i < this.metricsCnt; ++i) {
            ti = this.metricsTupleIdx[i];
            if (ti < 0 || this.measureTypes[i] == null) continue;
            this.measureTypes[i].fillTupleSimply(tuple, ti, metricsValues[i]);
        }
        if (this.advMeasureFillers.isEmpty()) {
            return null;
        }
        for (i = 0; i < this.advMeasureFillers.size(); ++i) {
            Object measureValue = metricsValues[this.advMeasureIndexInGTValues.get(i)];
            this.advMeasureFillers.get(i).reload(measureValue);
        }
        return this.advMeasureFillers;
    }
}

