/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.coordinate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.Collections2;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.MapDifference;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.coordinator.assign.AssignmentsCache;
import org.apache.kylin.stream.coordinator.coordinate.SegmentJobBuildInfo;
import org.apache.kylin.stream.coordinator.coordinate.StreamingCoordinator;
import org.apache.kylin.stream.coordinator.exception.ClusterStateException;
import org.apache.kylin.stream.coordinator.exception.StoreException;
import org.apache.kylin.stream.core.consumer.ConsumerStartProtocol;
import org.apache.kylin.stream.core.model.AssignRequest;
import org.apache.kylin.stream.core.model.ConsumerStatsResponse;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.Node;
import org.apache.kylin.stream.core.model.PauseConsumersRequest;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.apache.kylin.stream.core.model.ResumeConsumerRequest;
import org.apache.kylin.stream.core.model.StartConsumersRequest;
import org.apache.kylin.stream.core.model.StopConsumersRequest;
import org.apache.kylin.stream.core.model.stats.ReceiverCubeStats;
import org.apache.kylin.stream.core.source.ISourcePosition;
import org.apache.kylin.stream.core.source.ISourcePositionHandler;
import org.apache.kylin.stream.core.source.IStreamingSource;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.stream.core.source.StreamingSourceFactory;
import org.apache.kylin.stream.core.util.HDFSUtil;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverClusterManager {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverClusterManager.class);
    StreamingCoordinator coordinator;

    ReceiverClusterManager(StreamingCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    public StreamingCoordinator getCoordinator() {
        return this.coordinator;
    }

    void doReBalance(List<CubeAssignment> previousAssignments, List<CubeAssignment> newAssignments) {
        HashMap<String, CubeAssignment> previousCubeAssignMap = Maps.newHashMap();
        HashMap<String, CubeAssignment> newCubeAssignMap = Maps.newHashMap();
        for (CubeAssignment cubeAssignment : previousAssignments) {
            previousCubeAssignMap.put(cubeAssignment.getCubeName(), cubeAssignment);
        }
        for (CubeAssignment cubeAssignment : newAssignments) {
            newCubeAssignMap.put(cubeAssignment.getCubeName(), cubeAssignment);
        }
        try {
            Set preCubes = previousCubeAssignMap.keySet();
            Set newCubes = newCubeAssignMap.keySet();
            if (!preCubes.equals(newCubes)) {
                logger.error("previous assignment cubes:{}, new assignment cubes:{}", (Object)preCubes, (Object)newCubes);
                throw new IllegalStateException("previous cube assignments");
            }
            MapDifference diff = Maps.difference(previousCubeAssignMap, newCubeAssignMap);
            Map changedAssignments = diff.entriesDiffering();
            for (Map.Entry changedAssignmentEntry : changedAssignments.entrySet()) {
                String cubeName = (String)changedAssignmentEntry.getKey();
                MapDifference.ValueDifference cubeAssignDiff = changedAssignmentEntry.getValue();
                this.reassignCubeImpl(cubeName, (CubeAssignment)cubeAssignDiff.leftValue(), (CubeAssignment)cubeAssignDiff.rightValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void reassignCubeImpl(String cubeName, CubeAssignment preAssignments, CubeAssignment newAssignments) {
        logger.info("start cube reBalance, cube:{}, previous assignments:{}, new assignments:{}", cubeName, preAssignments, newAssignments);
        if (newAssignments.equals(preAssignments)) {
            logger.info("the new assignment is the same as the previous assignment, do nothing for this reassignment");
            return;
        }
        CubeInstance cubeInstance = this.getCoordinator().getCubeManager().getCube(cubeName);
        this.doReassignWithoutCommit(cubeInstance, preAssignments, newAssignments);
        MapDifference<Integer, List<Partition>> assignDiff = Maps.difference(preAssignments.getAssignments(), newAssignments.getAssignments());
        Map<Integer, List<Partition>> removedAssign = assignDiff.entriesOnlyOnLeft();
        for (Integer removedReplicaSet : removedAssign.keySet()) {
            newAssignments.addAssignment(removedReplicaSet, Lists.newArrayList());
        }
        logger.info("Commit reassign {} transaction.", (Object)cubeName);
        this.getCoordinator().getStreamMetadataStore().saveNewCubeAssignment(newAssignments);
        AssignmentsCache.getInstance().clearCubeCache(cubeName);
    }

    void doReassignWithoutCommit(CubeInstance cubeInstance, CubeAssignment preAssignments, CubeAssignment newAssignments) {
        ISourcePosition consumePosition;
        String cubeName = preAssignments.getCubeName();
        IStreamingSource streamingSource = StreamingSourceFactory.getStreamingSource(cubeInstance);
        MapDifference<Integer, List<Partition>> assignDiff = Maps.difference(preAssignments.getAssignments(), newAssignments.getAssignments());
        Map<Integer, List<Partition>> sameAssign = assignDiff.entriesInCommon();
        Map<Integer, List<Partition>> newAssign = assignDiff.entriesOnlyOnRight();
        Map<Integer, List<Partition>> removedAssign = assignDiff.entriesOnlyOnLeft();
        ArrayList<ISourcePosition> allPositions = Lists.newArrayList();
        ArrayList<ReplicaSet> successSyncReplicaSet = Lists.newArrayList();
        try {
            for (Map.Entry<Integer, List<Partition>> assignmentEntry : preAssignments.getAssignments().entrySet()) {
                Integer replicaSetID = assignmentEntry.getKey();
                if (sameAssign.containsKey(replicaSetID)) {
                    logger.info("the assignment is not changed for cube:{}, replicaSet:{}", (Object)cubeName, (Object)replicaSetID);
                    continue;
                }
                ReplicaSet rs = this.getCoordinator().getStreamMetadataStore().getReplicaSet(replicaSetID);
                ISourcePosition position = this.syncAndStopConsumersInRs(streamingSource, cubeName, rs);
                allPositions.add(position);
                successSyncReplicaSet.add(rs);
            }
            consumePosition = streamingSource.getSourcePositionHandler().mergePositions(allPositions, ISourcePositionHandler.MergeStrategy.KEEP_LARGE);
            logger.info("the consumer position for cube:{} is:{}", (Object)cubeName, (Object)consumePosition);
        }
        catch (Exception e) {
            logger.error("fail to sync assign replicaSet for cube:" + cubeName, e);
            Set needRollback = successSyncReplicaSet.stream().map(ReplicaSet::getReplicaSetID).collect(Collectors.toSet());
            for (ReplicaSet rs : successSyncReplicaSet) {
                StartConsumersRequest request = new StartConsumersRequest();
                request.setCube(cubeName);
                try {
                    this.startConsumersInReplicaSet(rs, request);
                    needRollback.remove(rs.getReplicaSetID());
                }
                catch (IOException e1) {
                    logger.error("fail to start consumers for cube:" + cubeName + " replicaSet:" + rs.getReplicaSetID(), e1);
                }
            }
            if (needRollback.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_SUCCESS, ClusterStateException.TransactionStep.STOP_AND_SNYC, "", e);
            }
            StringBuilder str = new StringBuilder();
            try {
                str.append("Fail restart:").append(JsonUtil.writeValueAsString(needRollback));
            }
            catch (JsonProcessingException jpe) {
                logger.error("", jpe);
            }
            throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.STOP_AND_SNYC, str.toString(), e);
        }
        ArrayList<ReplicaSet> successAssigned = Lists.newArrayList();
        ArrayList<ReplicaSet> successStarted = Lists.newArrayList();
        HashSet<Node> failedConvertToImmutableNodes = new HashSet<Node>();
        try {
            Integer replicaSetID;
            for (Map.Entry<Integer, List<Partition>> cubeAssignmentEntry : newAssignments.getAssignments().entrySet()) {
                replicaSetID = cubeAssignmentEntry.getKey();
                if (sameAssign.containsKey(replicaSetID)) continue;
                ReplicaSet replicaSet = this.getCoordinator().getStreamMetadataStore().getReplicaSet(replicaSetID);
                logger.info("assign cube:{} to replicaSet:{}", (Object)cubeName, (Object)replicaSetID);
                this.assignCubeToReplicaSet(replicaSet, cubeName, cubeAssignmentEntry.getValue(), false, true);
                successAssigned.add(replicaSet);
            }
            for (Map.Entry<Integer, List<Partition>> cubeAssignmentEntry : newAssignments.getAssignments().entrySet()) {
                replicaSetID = cubeAssignmentEntry.getKey();
                if (sameAssign.containsKey(replicaSetID)) continue;
                ConsumerStartProtocol consumerStartProtocol = new ConsumerStartProtocol(streamingSource.getSourcePositionHandler().serializePosition(consumePosition.advance()));
                ReplicaSet replicaSet = this.getCoordinator().getStreamMetadataStore().getReplicaSet(replicaSetID);
                StartConsumersRequest startRequest = new StartConsumersRequest();
                startRequest.setCube(cubeName);
                startRequest.setStartProtocol(consumerStartProtocol);
                logger.info("start consumers for cube:{}, replicaSet:{}, startRequest:{}", cubeName, replicaSetID, startRequest);
                this.startConsumersInReplicaSet(replicaSet, startRequest);
                successStarted.add(replicaSet);
            }
            for (Map.Entry<Integer, List<Partition>> removeAssignmentEntry : removedAssign.entrySet()) {
                replicaSetID = removeAssignmentEntry.getKey();
                logger.info("make cube immutable for cube:{}, replicaSet{}", (Object)cubeName, (Object)replicaSetID);
                ReplicaSet replicaSet = this.getCoordinator().getStreamMetadataStore().getReplicaSet(replicaSetID);
                List<Node> list = this.makeCubeImmutableInReplicaSet(replicaSet, cubeName);
                failedConvertToImmutableNodes.addAll(list);
            }
            if (!failedConvertToImmutableNodes.isEmpty()) {
                throw new IOException("Failed to convert to immutable state. ");
            }
            logger.info("Finish cube reassign for cube:{} .", (Object)cubeName);
        }
        catch (IOException e) {
            logger.error("Fail to start consumers for cube:" + cubeName, e);
            Set rollbackStarted = successStarted.stream().map(ReplicaSet::getReplicaSetID).collect(Collectors.toSet());
            for (ReplicaSet replicaSet : successStarted) {
                try {
                    StopConsumersRequest stopConsumersRequest = new StopConsumersRequest();
                    stopConsumersRequest.setCube(cubeName);
                    if (newAssign.containsKey(replicaSet.getReplicaSetID())) {
                        stopConsumersRequest.setRemoveData(true);
                    }
                    this.stopConsumersInReplicaSet(replicaSet, stopConsumersRequest);
                    rollbackStarted.remove(replicaSet.getReplicaSetID());
                }
                catch (IOException iOException) {
                    logger.error("fail to stop consumers for cube:" + cubeName + " replicaSet:" + replicaSet.getReplicaSetID(), iOException);
                }
            }
            Set rollbackAssigned = successAssigned.stream().map(ReplicaSet::getReplicaSetID).collect(Collectors.toSet());
            for (ReplicaSet replicaSet : successAssigned) {
                try {
                    List<Partition> partitions = preAssignments.getPartitionsByReplicaSetID(replicaSet.getReplicaSetID());
                    this.assignCubeToReplicaSet(replicaSet, cubeName, partitions, true, true);
                    rollbackAssigned.remove(replicaSet.getReplicaSetID());
                }
                catch (IOException e1) {
                    logger.error("fail to start consumers for cube:" + cubeName + " replicaSet:" + replicaSet.getReplicaSetID(), e1);
                }
            }
            HashSet hashSet = new HashSet(failedConvertToImmutableNodes);
            for (Node node : failedConvertToImmutableNodes) {
                try {
                    this.getCoordinator().makeCubeImmutableForReceiver(node, cubeName);
                    hashSet.remove(node);
                }
                catch (IOException ioe) {
                    logger.error("fail to make cube immutable for cube:" + cubeName + " to " + node, ioe);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            try {
                stringBuilder.append("FailStarted:").append(JsonUtil.writeValueAsString(rollbackStarted)).append(";");
                stringBuilder.append("FailAssigned:").append(JsonUtil.writeValueAsString(rollbackAssigned)).append(";");
                stringBuilder.append("FailRemotedPresisted:").append(JsonUtil.writeValueAsString(hashSet));
            }
            catch (JsonProcessingException jpe) {
                logger.error("", jpe);
            }
            String failedInfo = stringBuilder.toString();
            if (!rollbackStarted.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.START_NEW, failedInfo, e);
            }
            if (!rollbackAssigned.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.ASSIGN_NEW, failedInfo, e);
            }
            if (!hashSet.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.MAKE_IMMUTABLE, failedInfo, e);
            }
            throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_SUCCESS, ClusterStateException.TransactionStep.ASSIGN_NEW, failedInfo, e);
        }
    }

    ISourcePosition syncAndStopConsumersInRs(final IStreamingSource streamingSource, String cubeName, ReplicaSet replicaSet) throws IOException {
        if (replicaSet.getNodes().size() > 1) {
            logger.info("sync consume for cube:{}, replicaSet:{}", (Object)cubeName, (Object)replicaSet.getReplicaSetID());
            PauseConsumersRequest suspendRequest = new PauseConsumersRequest();
            suspendRequest.setCube(cubeName);
            List<ConsumerStatsResponse> allReceiverConsumeState = this.pauseConsumersInReplicaSet(replicaSet, suspendRequest);
            List<ISourcePosition> consumePositionList = Lists.transform(allReceiverConsumeState, new Function<ConsumerStatsResponse, ISourcePosition>(){

                @Override
                @Nullable
                public ISourcePosition apply(@Nullable ConsumerStatsResponse input) {
                    return streamingSource.getSourcePositionHandler().parsePosition(input.getConsumePosition());
                }
            });
            ISourcePosition consumePosition = streamingSource.getSourcePositionHandler().mergePositions(consumePositionList, ISourcePositionHandler.MergeStrategy.KEEP_LARGE);
            ResumeConsumerRequest resumeRequest = new ResumeConsumerRequest();
            resumeRequest.setCube(cubeName);
            resumeRequest.setResumeToPosition(streamingSource.getSourcePositionHandler().serializePosition(consumePosition));
            this.resumeConsumersInReplicaSet(replicaSet, resumeRequest);
            return consumePosition;
        }
        if (replicaSet.getNodes().size() == 1) {
            Node receiver = replicaSet.getNodes().iterator().next();
            StopConsumersRequest request = new StopConsumersRequest();
            request.setCube(cubeName);
            logger.info("stop consumers for cube:{}, receiver:{}", (Object)cubeName, (Object)receiver);
            List<ConsumerStatsResponse> stopResponse = this.stopConsumersInReplicaSet(replicaSet, request);
            return streamingSource.getSourcePositionHandler().parsePosition(stopResponse.get(0).getConsumePosition());
        }
        return null;
    }

    void startConsumersInReplicaSet(ReplicaSet rs, StartConsumersRequest request) throws IOException {
        for (Node node : rs.getNodes()) {
            this.getCoordinator().startConsumersForReceiver(node, request);
        }
    }

    List<Node> makeCubeImmutableInReplicaSet(ReplicaSet rs, String cubeName) {
        ArrayList<Node> failedNodes = new ArrayList<Node>();
        for (Node node : rs.getNodes()) {
            try {
                this.getCoordinator().makeCubeImmutableForReceiver(node, cubeName);
            }
            catch (IOException ioe) {
                logger.error(String.format(Locale.ROOT, "Convert %s to immutable for node %s failed.", cubeName, node.toNormalizeString()), ioe);
                failedNodes.add(node);
            }
        }
        return failedNodes;
    }

    List<ConsumerStatsResponse> resumeConsumersInReplicaSet(ReplicaSet rs, ResumeConsumerRequest request) throws IOException {
        ArrayList<ConsumerStatsResponse> consumerStats = Lists.newArrayList();
        for (Node node : rs.getNodes()) {
            consumerStats.add(this.getCoordinator().resumeConsumersForReceiver(node, request));
        }
        return consumerStats;
    }

    List<ConsumerStatsResponse> stopConsumersInReplicaSet(ReplicaSet rs, StopConsumersRequest request) throws IOException {
        ArrayList<ConsumerStatsResponse> consumerStats = Lists.newArrayList();
        for (Node node : rs.getNodes()) {
            consumerStats.add(this.getCoordinator().stopConsumersForReceiver(node, request));
        }
        return consumerStats;
    }

    List<ConsumerStatsResponse> pauseConsumersInReplicaSet(ReplicaSet rs, PauseConsumersRequest request) throws IOException {
        ArrayList<ConsumerStatsResponse> consumerStats = Lists.newArrayList();
        ArrayList<Node> successReceivers = Lists.newArrayList();
        try {
            for (Node node : rs.getNodes()) {
                consumerStats.add(this.getCoordinator().pauseConsumersForReceiver(node, request));
                successReceivers.add(node);
            }
        }
        catch (IOException ioe) {
            logger.info("Roll back pause consumers for receivers: {}", (Object)successReceivers);
            ResumeConsumerRequest resumeRequest = new ResumeConsumerRequest();
            resumeRequest.setCube(request.getCube());
            for (Node receiver : successReceivers) {
                this.getCoordinator().resumeConsumersForReceiver(receiver, resumeRequest);
            }
            throw ioe;
        }
        return consumerStats;
    }

    void assignCubeToReplicaSet(ReplicaSet rs, String cubeName, List<Partition> partitions, boolean startConsumer, boolean failFast) throws IOException {
        boolean atLeastOneAssigned = false;
        IOException exception = null;
        AssignRequest assignRequest = new AssignRequest();
        assignRequest.setCubeName(cubeName);
        assignRequest.setPartitions(partitions);
        assignRequest.setStartConsumers(startConsumer);
        for (Node node : rs.getNodes()) {
            try {
                this.getCoordinator().assignToReceiver(node, assignRequest);
                atLeastOneAssigned = true;
            }
            catch (IOException e) {
                if (failFast) {
                    throw e;
                }
                exception = e;
                logger.error("Cube:" + cubeName + " consumers start fail for node:" + node.toString(), e);
            }
        }
        if (!atLeastOneAssigned && exception != null) {
            throw exception;
        }
    }

    protected boolean segmentBuildComplete(CubingJob cubingJob, CubeInstance cubeInstance, CubeSegment cubeSegment, SegmentJobBuildInfo segmentBuildInfo) {
        String cubeName = segmentBuildInfo.cubeName;
        String segmentName = segmentBuildInfo.segmentName;
        if (!this.checkPreviousSegmentReady(cubeSegment)) {
            logger.warn("Segment:{}'s previous segment is not ready, will not set the segment to ready.", (Object)cubeSegment);
            return false;
        }
        if (!SegmentStatusEnum.READY.equals(cubeSegment.getStatus())) {
            try {
                this.promoteNewSegment(cubingJob, cubeInstance, cubeSegment);
            }
            catch (IOException storeException) {
                throw new StoreException("Promote failed because of metadata store.", storeException);
            }
            logger.debug("Promote {} succeed.", (Object)segmentName);
        } else {
            logger.debug("Segment status is: {}", (Object)cubeSegment.getStatus());
        }
        CubeAssignment assignments = this.getCoordinator().getStreamMetadataStore().getAssignmentsByCube(cubeName);
        for (int replicaSetID : assignments.getReplicaSetIDs()) {
            ReplicaSet rs = this.getCoordinator().getStreamMetadataStore().getReplicaSet(replicaSetID);
            for (Node node : rs.getNodes()) {
                try {
                    this.getCoordinator().notifyReceiverBuildSuccess(node, cubeName, segmentName);
                }
                catch (IOException e) {
                    logger.error("error when remove cube segment for receiver:" + node, e);
                }
            }
            if (!assignments.getPartitionsByReplicaSetID(replicaSetID).isEmpty()) continue;
            logger.info("No partition is assign to the replicaSet:{}, check whether there are local segments on the rs.", (Object)replicaSetID);
            Node leader = rs.getLeader();
            try {
                ReceiverCubeStats receiverCubeStats = this.getCoordinator().getReceiverAdminClient().getReceiverCubeStats(leader, cubeName);
                Set<String> segments = receiverCubeStats.getSegmentStatsMap().keySet();
                if (!segments.isEmpty()) continue;
                logger.info("no local segments exist for replicaSet:{}, cube:{}, update assignments.", (Object)replicaSetID, (Object)cubeName);
                assignments.removeAssignment(replicaSetID);
                this.getCoordinator().getStreamMetadataStore().saveNewCubeAssignment(assignments);
            }
            catch (IOException e) {
                logger.error("error when get receiver cube stats from:" + leader, e);
            }
        }
        this.getCoordinator().getStreamMetadataStore().removeSegmentBuildState(cubeName, segmentName);
        logger.info("Try to remove the hdfs files for cube:{} segment:{}", (Object)cubeName, (Object)segmentName);
        this.removeHDFSFiles(cubeName, segmentName);
        return true;
    }

    void promoteNewSegment(CubingJob cubingJob, CubeInstance cubeInstance, CubeSegment cubeSegment) throws IOException {
        logger.debug("Try transfer segment's {} state to ready.", (Object)cubeSegment.getName());
        long sourceCount = cubingJob.findSourceRecordCount();
        long sourceSizeBytes = cubingJob.findSourceSizeBytes();
        long cubeSizeBytes = cubingJob.findCubeSizeBytes();
        Map<Integer, String> sourceCheckpoint = this.getCoordinator().getStreamMetadataStore().getSourceCheckpoint(cubeInstance.getName(), cubeSegment.getName());
        final ISourcePositionHandler positionOperator = StreamingSourceFactory.getStreamingSource(cubeInstance).getSourcePositionHandler();
        Collection<ISourcePosition> sourcePositions = Collections2.transform(sourceCheckpoint.values(), new Function<String, ISourcePosition>(){

            @Override
            @Nullable
            public ISourcePosition apply(@Nullable String input) {
                return positionOperator.parsePosition(input);
            }
        });
        ISourcePosition sourcePosition = positionOperator.mergePositions(sourcePositions, ISourcePositionHandler.MergeStrategy.KEEP_SMALL);
        cubeSegment.setLastBuildJobID(cubingJob.getId());
        cubeSegment.setLastBuildTime(System.currentTimeMillis());
        cubeSegment.setSizeKB(cubeSizeBytes / 1024L);
        cubeSegment.setInputRecords(sourceCount);
        cubeSegment.setInputRecordsSize(sourceSizeBytes);
        cubeSegment.setStreamSourceCheckpoint(positionOperator.serializePosition(sourcePosition));
        this.getCoordinator().getCubeManager().promoteNewlyBuiltSegments(cubeInstance, cubeSegment);
    }

    boolean checkPreviousSegmentReady(CubeSegment currSegment) {
        long segmentEnd;
        long currSegmentStart = (Long)currSegment.getTSRange().start.v;
        CubeInstance cubeInstance = currSegment.getCubeInstance();
        Segments<CubeSegment> segments = cubeInstance.getSegments();
        long previousSegmentEnd = -1L;
        for (CubeSegment segment : segments) {
            segmentEnd = (Long)segment.getTSRange().end.v;
            if (segmentEnd > currSegmentStart || segmentEnd <= previousSegmentEnd) continue;
            previousSegmentEnd = segmentEnd;
        }
        if (previousSegmentEnd == -1L) {
            return true;
        }
        for (CubeSegment segment : segments) {
            segmentEnd = (Long)segment.getTSRange().end.v;
            if (segmentEnd != previousSegmentEnd || !SegmentStatusEnum.READY.equals(segment.getStatus())) continue;
            return true;
        }
        return false;
    }

    private void removeHDFSFiles(String cubeName, String segmentName) {
        String segmentHDFSPath = HDFSUtil.getStreamingSegmentFilePath(cubeName, segmentName);
        try {
            FileSystem fs = HadoopUtil.getFileSystem(segmentHDFSPath);
            logger.info("Deleting segment data in HDFS {}", (Object)segmentHDFSPath);
            fs.delete(new Path(segmentHDFSPath), true);
        }
        catch (Exception e) {
            logger.error("error when remove hdfs file, hdfs path:{}", (Object)segmentHDFSPath);
        }
    }
}

