/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.enumerator.OLAPQuery;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.schema.OLAPSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPTable
extends AbstractQueryableTable
implements TranslatableTable {
    protected static final Logger logger = LoggerFactory.getLogger(OLAPTable.class);
    public static final Map<SqlTypeName, String> DATATYPE_MAPPING = Maps.newHashMap();
    private static Map<String, SqlTypeName> SQLTYPE_MAPPING;
    private static Map<String, SqlTypeName> REGEX_SQLTYPE_MAPPING;
    private final boolean exposeMore;
    private final OLAPSchema olapSchema;
    private final TableDesc sourceTable;
    protected RelDataType rowType;
    private List<ColumnDesc> sourceColumns;

    public OLAPTable(OLAPSchema schema, TableDesc tableDesc, boolean exposeMore) {
        super(Object[].class);
        this.exposeMore = exposeMore;
        this.olapSchema = schema;
        this.sourceTable = tableDesc;
        this.rowType = null;
    }

    public OLAPSchema getSchema() {
        return this.olapSchema;
    }

    public TableDesc getSourceTable() {
        return this.sourceTable;
    }

    public String getTableName() {
        return this.sourceTable.getIdentity();
    }

    public List<ColumnDesc> getSourceColumns() {
        if (this.sourceColumns == null) {
            this.sourceColumns = this.listSourceColumns();
        }
        return this.sourceColumns;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.sourceColumns = this.getSourceColumns();
            this.rowType = this.deriveRowType(typeFactory);
        }
        return this.rowType;
    }

    private RelDataType deriveRowType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        for (ColumnDesc column : this.sourceColumns) {
            RelDataType sqlType = OLAPTable.createSqlType(typeFactory, column.getUpgradedType(), column.isNullable());
            sqlType = SqlTypeUtil.addCharsetAndCollation((RelDataType)sqlType, (RelDataTypeFactory)typeFactory);
            fieldInfo.add(column.getName(), sqlType);
        }
        return typeFactory.createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
    }

    public static RelDataType createSqlType(RelDataTypeFactory typeFactory, DataType dataType, boolean isNullable) {
        RelDataType result;
        SqlTypeName sqlTypeName = SQLTYPE_MAPPING.get(dataType.getName());
        if (sqlTypeName == null) {
            for (String reg : REGEX_SQLTYPE_MAPPING.keySet()) {
                Pattern pattern = Pattern.compile(reg);
                if (!pattern.matcher(dataType.getName()).matches()) continue;
                sqlTypeName = REGEX_SQLTYPE_MAPPING.get(reg);
                break;
            }
        }
        if (sqlTypeName == null) {
            throw new IllegalArgumentException("Unrecognized data type " + dataType);
        }
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if (sqlTypeName == SqlTypeName.ARRAY) {
            String innerTypeName = dataType.getName().split("<|>")[1];
            result = typeFactory.createArrayType(OLAPTable.createSqlType(typeFactory, DataType.getType(innerTypeName), false), -1L);
        } else {
            result = precision >= 0 && scale >= 0 ? typeFactory.createSqlType(sqlTypeName, precision, scale) : (precision >= 0 ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName));
        }
        result = isNullable ? typeFactory.createTypeWithNullability(result, true) : typeFactory.createTypeWithNullability(result, false);
        return result;
    }

    private List<ColumnDesc> listSourceColumns() {
        ProjectManager mgr = ProjectManager.getInstance(this.olapSchema.getConfig());
        List<ColumnDesc> tableColumns = mgr.listExposedColumns(this.olapSchema.getProjectName(), this.sourceTable, this.exposeMore);
        ArrayList metricColumns = Lists.newArrayList();
        List<MeasureDesc> countMeasures = mgr.listEffectiveRewriteMeasures(this.olapSchema.getProjectName(), this.sourceTable.getIdentity());
        HashSet<String> metFields = new HashSet<String>();
        for (MeasureDesc m : countMeasures) {
            FunctionDesc func = m.getFunction();
            String fieldName = func.getRewriteFieldName();
            if (metFields.contains(fieldName)) continue;
            metFields.add(fieldName);
            ColumnDesc fakeCountCol = func.newFakeRewriteColumn(this.sourceTable);
            metricColumns.add(fakeCountCol);
        }
        Collections.sort(tableColumns, new Comparator<ColumnDesc>(){

            @Override
            public int compare(ColumnDesc o1, ColumnDesc o2) {
                return o1.getZeroBasedIndex() - o2.getZeroBasedIndex();
            }
        });
        return Lists.newArrayList((Iterable)Iterables.concat(tableColumns, (Iterable)metricColumns));
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = this.identityList(fieldCount);
        return new OLAPTableScan(context.getCluster(), relOptTable, this, fields);
    }

    protected int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                OLAPQuery query = new OLAPQuery(OLAPQuery.EnumeratorTypeEnum.OLAP, 0);
                return query.enumerator();
            }
        };
    }

    public Statistic getStatistic() {
        ArrayList keys = new ArrayList();
        return Statistics.of((double)100.0, keys);
    }

    public String toString() {
        return "OLAPTable {" + this.getTableName() + "}";
    }

    public Enumerable<Object[]> executeOLAPQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.OLAP, ctxSeq);
    }

    public Enumerable<Object[]> executeLookupTableQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.LOOKUP_TABLE, ctxSeq);
    }

    public Enumerable<Object[]> executeColumnDictionaryQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.COL_DICT, ctxSeq);
    }

    public Enumerable<Object[]> executeHiveQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.HIVE, ctxSeq);
    }

    static {
        DATATYPE_MAPPING.put(SqlTypeName.CHAR, "char");
        DATATYPE_MAPPING.put(SqlTypeName.VARCHAR, "varchar");
        DATATYPE_MAPPING.put(SqlTypeName.BOOLEAN, "boolean");
        DATATYPE_MAPPING.put(SqlTypeName.INTEGER, "integer");
        DATATYPE_MAPPING.put(SqlTypeName.TINYINT, "tinyint");
        DATATYPE_MAPPING.put(SqlTypeName.SMALLINT, "smallint");
        DATATYPE_MAPPING.put(SqlTypeName.BIGINT, "bigint");
        DATATYPE_MAPPING.put(SqlTypeName.DECIMAL, "decimal");
        DATATYPE_MAPPING.put(SqlTypeName.FLOAT, "float");
        DATATYPE_MAPPING.put(SqlTypeName.REAL, "real");
        DATATYPE_MAPPING.put(SqlTypeName.DOUBLE, "double");
        DATATYPE_MAPPING.put(SqlTypeName.DATE, "date");
        DATATYPE_MAPPING.put(SqlTypeName.TIME, "time");
        DATATYPE_MAPPING.put(SqlTypeName.TIMESTAMP, "timestamp");
        DATATYPE_MAPPING.put(SqlTypeName.ANY, "any");
        SQLTYPE_MAPPING = new HashMap<String, SqlTypeName>();
        REGEX_SQLTYPE_MAPPING = new HashMap<String, SqlTypeName>();
        SQLTYPE_MAPPING.put("char", SqlTypeName.CHAR);
        SQLTYPE_MAPPING.put("varchar", SqlTypeName.VARCHAR);
        SQLTYPE_MAPPING.put("boolean", SqlTypeName.BOOLEAN);
        SQLTYPE_MAPPING.put("integer", SqlTypeName.INTEGER);
        SQLTYPE_MAPPING.put("tinyint", SqlTypeName.TINYINT);
        SQLTYPE_MAPPING.put("smallint", SqlTypeName.SMALLINT);
        SQLTYPE_MAPPING.put("bigint", SqlTypeName.BIGINT);
        SQLTYPE_MAPPING.put("decimal", SqlTypeName.DECIMAL);
        SQLTYPE_MAPPING.put("numeric", SqlTypeName.DECIMAL);
        SQLTYPE_MAPPING.put("float", SqlTypeName.FLOAT);
        SQLTYPE_MAPPING.put("real", SqlTypeName.REAL);
        SQLTYPE_MAPPING.put("double", SqlTypeName.DOUBLE);
        SQLTYPE_MAPPING.put("date", SqlTypeName.DATE);
        SQLTYPE_MAPPING.put("time", SqlTypeName.TIME);
        SQLTYPE_MAPPING.put("timestamp", SqlTypeName.TIMESTAMP);
        SQLTYPE_MAPPING.put("any", SqlTypeName.ANY);
        REGEX_SQLTYPE_MAPPING.put("array\\<.+\\>", SqlTypeName.ARRAY);
    }
}

