/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;

public abstract class ExpressionDynamicFunctionDesc
extends DynamicFunctionDesc {
    protected TupleExpression tupleExpression;
    protected Set<TblColRef> filterColSet;
    protected Map<TblColRef, FunctionDesc> runtimeFuncMap;

    public ExpressionDynamicFunctionDesc(ParameterDesc parameter, String expression, String returnType, TupleExpression tupleExpression) {
        super(parameter, expression, returnType);
        this.tupleExpression = tupleExpression;
        Pair<Set<TblColRef>, Set<TblColRef>> colsPair = ExpressionColCollector.collectColumnsPair(tupleExpression);
        this.filterColSet = colsPair.getFirst();
        Set<TblColRef> measureColumns = colsPair.getSecond();
        this.runtimeFuncMap = Maps.newHashMapWithExpectedSize((int)measureColumns.size());
        for (TblColRef column : measureColumns) {
            this.runtimeFuncMap.put(column, this.constructRuntimeFunction(column));
        }
    }

    public TupleExpression getTupleExpression() {
        return this.tupleExpression;
    }

    @Override
    public Set<TblColRef> getRuntimeDimensions() {
        return this.filterColSet;
    }

    public Set<TblColRef> getRuntimeMeasures() {
        return Collections.unmodifiableSet(this.runtimeFuncMap.keySet());
    }

    @Override
    public Map<TblColRef, FunctionDesc> getRuntimeFuncMap() {
        return this.runtimeFuncMap;
    }

    @Override
    public void setRuntimeFuncMap(Map<TblColRef, FunctionDesc> funcMap) {
        this.runtimeFuncMap = funcMap;
        this.resetReturnType();
    }

    protected abstract void resetReturnType();
}

