/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import java.util.Map;
import java.util.Set;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.impl.threadpool.JobExecutor;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FetcherRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FetcherRunner.class);
    protected JobEngineConfig jobEngineConfig;
    protected DefaultContext context;
    protected JobExecutor jobExecutor;
    protected volatile boolean fetchFailed = false;
    protected Set<String> succeedJobs = Sets.newHashSet();
    protected static int nRunning;
    protected static int nReady;
    protected static int nStopped;
    protected static int nOthers;
    protected static int nError;
    protected static int nDiscarded;
    protected static int nSUCCEED;

    public FetcherRunner(JobEngineConfig jobEngineConfig, DefaultContext context, JobExecutor jobExecutor) {
        this.jobEngineConfig = jobEngineConfig;
        this.context = context;
        this.jobExecutor = jobExecutor;
    }

    protected boolean isJobPoolFull() {
        Map<String, Executable> runningJobs = this.context.getRunningJobs();
        if (runningJobs.size() >= this.jobEngineConfig.getMaxConcurrentJobLimit()) {
            logger.warn("There are too many jobs running, Job Fetch will wait until next schedule time");
            return true;
        }
        return false;
    }

    protected void addToJobPool(AbstractExecutable executable, int priority) {
        String jobDesc = executable.toString();
        logger.info(jobDesc + " prepare to schedule and its priority is " + priority);
        try {
            this.context.addRunningJob(executable);
            this.jobExecutor.execute(executable);
            logger.info(jobDesc + " scheduled");
        }
        catch (Exception ex) {
            this.context.removeRunningJob(executable);
            logger.warn(jobDesc + " fail to schedule", ex);
        }
    }

    protected void jobStateCount(String id) {
        Output outputDigest = this.getExecutableManager().getOutputDigest(id);
        if (outputDigest.getState() == ExecutableState.SUCCEED) {
            this.succeedJobs.add(id);
            ++nSUCCEED;
        } else if (outputDigest.getState() == ExecutableState.ERROR) {
            ++nError;
        } else if (outputDigest.getState() == ExecutableState.DISCARDED) {
            ++nDiscarded;
        } else if (outputDigest.getState() == ExecutableState.STOPPED) {
            ++nStopped;
        } else if (this.fetchFailed) {
            this.getExecutableManager().forceKillJob(id);
            ++nError;
        } else {
            ++nOthers;
        }
    }

    @VisibleForTesting
    void setFetchFailed(boolean fetchFailed) {
        this.fetchFailed = fetchFailed;
    }

    ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance(this.jobEngineConfig.getConfig());
    }
}

