/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.mr.steps.MergeDictionaryJob;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeDictionaryMapper
extends KylinMapper<IntWritable, NullWritable, IntWritable, Text> {
    private static final Logger logger = LoggerFactory.getLogger(MergeDictionaryMapper.class);
    List<CubeSegment> mergingSegments;
    TblColRef[] tblColRefs;
    DictionaryManager dictMgr;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException, InterruptedException {
        super.doSetup(context);
        SerializableConfiguration sConf = new SerializableConfiguration(context.getConfiguration());
        String metaUrl = context.getConfiguration().get("metaUrl");
        String cubeName = context.getConfiguration().get("cubename");
        String segmentIds = context.getConfiguration().get(MergeDictionaryJob.OPTION_MERGE_SEGMENT_IDS.getOpt());
        KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
        CubeInstance cubeInstance = CubeManager.getInstance(kylinConfig).getCube(cubeName);
        CubeDesc cubeDesc = CubeDescManager.getInstance(kylinConfig).getCubeDesc(cubeInstance.getDescName());
        this.mergingSegments = this.getMergingSegments(cubeInstance, StringUtil.splitByComma(segmentIds));
        this.tblColRefs = cubeDesc.getAllColumnsNeedDictionaryBuilt().toArray(new TblColRef[0]);
        this.dictMgr = DictionaryManager.getInstance(kylinConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMap(IntWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        block17: {
            block16: {
                int index = key.get();
                if (index >= this.tblColRefs.length) break block16;
                TblColRef col = this.tblColRefs[index];
                ArrayList<DictionaryInfo> dictInfos = Lists.newArrayList();
                for (CubeSegment segment : this.mergingSegments) {
                    DictionaryInfo dictInfo;
                    if (segment.getDictResPath(col) == null || (dictInfo = this.dictMgr.getDictionaryInfo(segment.getDictResPath(col))) == null || dictInfos.contains(dictInfo)) continue;
                    dictInfos.add(dictInfo);
                }
                DictionaryInfo mergedDictInfo = this.dictMgr.mergeDictionary(dictInfos);
                String tblCol = col.getTableAlias() + ":" + col.getName();
                String dictInfoPath = mergedDictInfo == null ? "" : mergedDictInfo.getResourcePath();
                context.write((Object)new IntWritable(-1), (Object)new Text(tblCol + "=" + dictInfoPath));
                break block17;
            }
            KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(new SerializableConfiguration(context.getConfiguration()), context.getConfiguration().get("metaUrl"));
            String cubeName = context.getConfiguration().get("cubename");
            String segmentId = context.getConfiguration().get("segmentId");
            String statOutputPath = context.getConfiguration().get(MergeDictionaryJob.OPTION_OUTPUT_PATH_STAT.getOpt());
            CubeInstance cubeInstance = CubeManager.getInstance(kylinConfig).getCube(cubeName);
            logger.info("Statistics output path: {}", (Object)statOutputPath);
            CubeSegment newSegment = cubeInstance.getSegmentById(segmentId);
            ResourceStore rs = ResourceStore.getStore(kylinConfig);
            HashMap<Long, HLLCounter> cuboidHLLMap = Maps.newHashMap();
            Configuration conf = null;
            int averageSamplingPercentage = 0;
            long sourceRecordCount = 0L;
            long effectiveTimeRange = 0L;
            for (CubeSegment cubeSegment : this.mergingSegments) {
                File tempFile;
                String filePath = cubeSegment.getStatisticsResourcePath();
                InputStream is = rs.getResource(filePath).content();
                FileOutputStream tempFileStream = null;
                try {
                    tempFile = File.createTempFile(segmentId, ".seq");
                    tempFileStream = new FileOutputStream(tempFile);
                    org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils.copy(is, (OutputStream)tempFileStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream((Closeable)is);
                    IOUtils.closeStream(tempFileStream);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)is);
                IOUtils.closeStream((Closeable)tempFileStream);
                FileSystem fs = HadoopUtil.getFileSystem("file:///" + tempFile.getAbsolutePath());
                SequenceFile.Reader reader = null;
                try {
                    conf = HadoopUtil.getCurrentConfiguration();
                    reader = new SequenceFile.Reader(fs, new Path(tempFile.getAbsolutePath()), conf);
                    LongWritable keyW = (LongWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                    BytesWritable valueW = (BytesWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                    while (reader.next((Writable)keyW, (Writable)valueW)) {
                        if (keyW.get() == 0L) {
                            averageSamplingPercentage += Bytes.toInt(valueW.getBytes());
                            continue;
                        }
                        if (keyW.get() == -3L) {
                            long perSourceRecordCount = Bytes.toLong(valueW.getBytes());
                            if (perSourceRecordCount <= 0L) continue;
                            sourceRecordCount += perSourceRecordCount;
                            effectiveTimeRange += cubeSegment.getTSRange().duration();
                            continue;
                        }
                        if (keyW.get() <= 0L) continue;
                        HLLCounter hll = new HLLCounter(kylinConfig.getCubeStatsHLLPrecision());
                        ByteArray byteArray = new ByteArray(valueW.getBytes());
                        hll.readRegisters(byteArray.asBuffer());
                        if (cuboidHLLMap.get(keyW.get()) != null) {
                            ((HLLCounter)cuboidHLLMap.get(keyW.get())).merge(hll);
                            continue;
                        }
                        cuboidHLLMap.put(keyW.get(), hll);
                    }
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeStream((Closeable)reader);
            }
            sourceRecordCount = (long)((double)sourceRecordCount * (effectiveTimeRange == 0L ? 0.0 : (double)newSegment.getTSRange().duration() / (double)effectiveTimeRange));
            Path statisticsFilePath = new Path(statOutputPath, "cuboid_statistics.seq");
            CubeStatsWriter.writeCuboidStatistics(conf, new Path(statOutputPath), cuboidHLLMap, averageSamplingPercentage /= this.mergingSegments.size(), sourceRecordCount);
            FileSystem fs = HadoopUtil.getFileSystem(statisticsFilePath, conf);
            FSDataInputStream fis = fs.open(statisticsFilePath);
            try {
                String statisticsFileName = newSegment.getStatisticsResourcePath();
                rs.putResource(statisticsFileName, (InputStream)fis, System.currentTimeMillis());
            }
            finally {
                IOUtils.closeStream((Closeable)fis);
            }
            context.write((Object)new IntWritable(-1), (Object)new Text(""));
        }
    }

    private List<CubeSegment> getMergingSegments(CubeInstance cube, String[] segmentIds) {
        ArrayList<CubeSegment> result = Lists.newArrayListWithCapacity(segmentIds.length);
        for (String id : segmentIds) {
            result.add(cube.getSegmentById(id));
        }
        return result;
    }
}

