/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.dict;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDictionaryStore
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(LocalDictionaryStore.class);
    private RocksDB db;
    private File dictPath;
    private String baseStorePath = "DictCache";
    private Map<ByteArray, ColumnFamilyHandle> columnFamilyHandleMap = new HashMap<ByteArray, ColumnFamilyHandle>();
    String cubeName;

    public LocalDictionaryStore(String tableColumn) {
        this.dictPath = new File(this.baseStorePath, tableColumn);
        this.cubeName = tableColumn;
    }

    public void init(String[] cfs) throws Exception {
        logger.debug("Checking streaming dict local store for {} at {}.", (Object)this.cubeName, (Object)String.join((CharSequence)", ", cfs));
        if (!this.dictPath.exists() && this.dictPath.mkdirs()) {
            logger.warn("Create {} failed.", (Object)this.dictPath);
        }
        try (DBOptions options = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setMaxBackgroundCompactions(5).setWritableFileMaxBufferSize(409600L);){
            String dataPath = this.dictPath.getAbsolutePath() + "/data";
            ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptorList = new ArrayList<ColumnFamilyDescriptor>();
            ArrayList<ColumnFamilyHandle> columnFamilyHandleList = new ArrayList<ColumnFamilyHandle>();
            for (String family : cfs) {
                ColumnFamilyDescriptor columnFamilyDescriptor = new ColumnFamilyDescriptor(family.getBytes(StandardCharsets.UTF_8));
                columnFamilyDescriptorList.add(columnFamilyDescriptor);
            }
            logger.debug("Try to open rocksdb {}.", (Object)dataPath);
            this.db = RocksDB.open(options, dataPath, columnFamilyDescriptorList, columnFamilyHandleList);
            Preconditions.checkNotNull(this.db, "RocksDB cannot created for some reasons.");
            for (int i = 0; i < columnFamilyHandleList.size(); ++i) {
                this.columnFamilyHandleMap.put(new ByteArray(cfs[i].getBytes(StandardCharsets.UTF_8)), (ColumnFamilyHandle)columnFamilyHandleList.get(i));
            }
        }
        catch (Exception e) {
            logger.error("Init rocks db failed.", e);
            throw e;
        }
        logger.debug("Init local dict succeed.");
    }

    public boolean put(ByteArray column, String key, Integer value) {
        try {
            ColumnFamilyHandle handle = this.columnFamilyHandleMap.get(column);
            Preconditions.checkNotNull(handle, new String(column.array(), StandardCharsets.UTF_8) + " cannot find matched handle.");
            this.db.put(handle, key.getBytes(StandardCharsets.UTF_8), value.toString().getBytes(StandardCharsets.UTF_8));
            return true;
        }
        catch (Exception rdbe) {
            logger.error("Put failed.", rdbe);
            return false;
        }
    }

    public int encode(ByteArray column, String value) {
        byte[] values;
        try {
            ColumnFamilyHandle handle = this.columnFamilyHandleMap.get(column);
            Preconditions.checkNotNull(handle, new String(column.array(), StandardCharsets.UTF_8) + " cannot find matched handle.");
            values = this.db.get(handle, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception rdbe) {
            logger.error("Can not get from rocksDB.", rdbe);
            return -1;
        }
        if (values != null) {
            if (values.length == 0) {
                logger.warn("Empty values for {}", (Object)value);
                return -2;
            }
            try {
                return Integer.parseInt(new String(values, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                logger.error("parseInt " + new ByteArray(values).toString(), e);
                return -1;
            }
        }
        return -2;
    }

    @Override
    public void close() {
        logger.debug("Close rocks db.");
        for (ColumnFamilyHandle familyHandle : this.columnFamilyHandleMap.values()) {
            familyHandle.close();
        }
        this.db.close();
    }
}

