/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowCounterCLI {
    private static final Logger logger = LoggerFactory.getLogger(RowCounterCLI.class);

    public static void main(String[] args) throws IOException {
        if (args == null || args.length != 3) {
            logger.info("Usage: hbase org.apache.hadoop.util.RunJar kylin-job-latest.jar org.apache.kylin.job.tools.RowCounterCLI [HTABLE_NAME] [STARTKEY] [ENDKEY]");
            return;
        }
        logger.info(args[0]);
        String htableName = args[0];
        logger.info(args[1]);
        byte[] startKey = BytesUtil.fromReadableText(args[1]);
        logger.info(args[2]);
        byte[] endKey = BytesUtil.fromReadableText(args[2]);
        if (startKey == null) {
            logger.info("startkey is null ");
        } else {
            logger.info("startkey lenght: {}", (Object)startKey.length);
        }
        if (logger.isInfoEnabled()) {
            logger.info("start key in binary: {}", (Object)Bytes.toStringBinary(startKey));
            logger.info("end key in binary: {}", (Object)Bytes.toStringBinary(endKey));
        }
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        Scan scan = new Scan();
        scan.setCaching(512);
        scan.setCacheBlocks(true);
        scan.setStartRow(startKey);
        scan.setStopRow(endKey);
        logger.info("My Scan {}", (Object)scan);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table tableInterface = conn.getTable(TableName.valueOf((String)htableName));){
            Iterator iterator = tableInterface.getScanner(scan).iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (++counter % 1000 != 1) continue;
                logger.info("number of rows: {}", (Object)counter);
            }
            logger.info("number of rows: {}", (Object)counter);
        }
    }
}

