/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.SerializationUtils;
import org.apache.kylin.shaded.com.google.common.collect.Queues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentQueryResult
implements Serializable {
    private static final long serialVersionUID = 9047493994209284453L;
    private Collection<byte[]> regionResults;
    private byte[] cubeSegmentStatisticsBytes;

    public void setRegionResults(Collection<byte[]> regionResults) {
        this.regionResults = regionResults;
    }

    public Collection<byte[]> getRegionResults() {
        return this.regionResults;
    }

    public byte[] getCubeSegmentStatisticsBytes() {
        return this.cubeSegmentStatisticsBytes;
    }

    public void setCubeSegmentStatisticsBytes(byte[] cubeSegmentStatisticsBytes) {
        this.cubeSegmentStatisticsBytes = cubeSegmentStatisticsBytes;
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private volatile int regionsNum;
        private ConcurrentLinkedQueue<byte[]> queue;
        private AtomicInteger totalResultSize;
        private volatile int maxSegmentCacheSize;
        private byte[] cubeSegmentStatisticsBytes;

        public Builder(int regionsNum, int maxCacheResultSize) {
            this.regionsNum = regionsNum;
            this.queue = Queues.newConcurrentLinkedQueue();
            this.totalResultSize = new AtomicInteger();
            this.maxSegmentCacheSize = maxCacheResultSize;
        }

        public void putRegionResult(byte[] result) {
            this.totalResultSize.addAndGet(result.length);
            if (this.totalResultSize.get() > this.maxSegmentCacheSize) {
                logger.info("stop put result to cache, since the result size:{} is larger than configured size:{}", (Object)this.totalResultSize.get(), (Object)this.maxSegmentCacheSize);
                return;
            }
            this.queue.offer(result);
        }

        public void setCubeSegmentStatistics(QueryContext.CubeSegmentStatistics cubeSegmentStatistics) {
            this.cubeSegmentStatisticsBytes = cubeSegmentStatistics == null ? null : SerializationUtils.serialize(cubeSegmentStatistics);
        }

        public boolean isComplete() {
            return this.queue.size() == this.regionsNum;
        }

        public SegmentQueryResult build() {
            SegmentQueryResult result = new SegmentQueryResult();
            result.setCubeSegmentStatisticsBytes(this.cubeSegmentStatisticsBytes);
            result.setRegionResults(this.queue);
            return result;
        }
    }
}

