/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NotImplementedException;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.shaded.com.google.common.base.Throwables;

class ExpectedSizeIterator
implements Iterator<byte[]> {
    private final QueryContext queryContext;
    private final int expectedSize;
    private final BlockingQueue<byte[]> queue;
    private final long coprocessorTimeout;
    private final long deadline;
    private int current = 0;

    public ExpectedSizeIterator(QueryContext queryContext, int expectedSize, long coprocessorTimeout) {
        this.queryContext = queryContext;
        this.expectedSize = expectedSize;
        this.queue = new ArrayBlockingQueue<byte[]>(expectedSize);
        this.coprocessorTimeout = coprocessorTimeout;
        this.deadline = System.currentTimeMillis() + coprocessorTimeout * 10L;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.expectedSize;
    }

    @Override
    public byte[] next() {
        if (this.current >= this.expectedSize) {
            throw new NoSuchElementException("Won't have more data");
        }
        try {
            ++this.current;
            byte[] ret = null;
            while (ret == null && this.deadline > System.currentTimeMillis()) {
                this.checkState();
                ret = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
            }
            if (ret == null) {
                throw new RuntimeException("Timeout visiting cube! Check why coprocessor exception is not sent back? In coprocessor Self-termination is checked every 100 scanned rows, the configured timeout(" + this.coprocessorTimeout + ") cannot support this many scans?");
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Error when waiting queue", e);
        }
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    public void append(byte[] data) {
        this.checkState();
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("error when waiting queue", e);
        }
    }

    private void checkState() {
        if (this.queryContext.isStopped()) {
            Throwable throwable = this.queryContext.getThrowable();
            if (throwable != null) {
                throw Throwables.propagate(throwable);
            }
            throw new IllegalStateException("the query is stopped: " + this.queryContext.getStopReason());
        }
    }
}

