/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.KylinEnumerableUnion;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPUnionRel
extends Union
implements OLAPRel {
    ColumnRowType columnRowType;
    OLAPContext context;

    public OLAPUnionRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
        Preconditions.checkArgument(this.getConvention() == CONVENTION);
        for (RelNode child : inputs) {
            Preconditions.checkArgument(this.getConvention() == child.getConvention());
        }
    }

    @Override
    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new OLAPUnionRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        boolean contextNotNull = this.context != null;
        return super.explainTerms(pw).item("ctx", this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization).itemIf("all", this.all, true);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.allocateContext();
        this.context = implementor.getContext();
        int n = this.getInputs().size();
        for (int i = 0; i < n; ++i) {
            implementor.fixSharedOlapTableScanAt(this, i);
            implementor.visitChild(this.getInputs().get(i), this);
            if (implementor.getContext() == this.context) continue;
            implementor.freeContext();
        }
        this.columnRowType = this.buildColumnRowType();
    }

    private ColumnRowType buildColumnRowType() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput(0)).getColumnRowType();
        ArrayList<TblColRef> columns = Lists.newArrayList();
        ArrayList<TupleExpression> sourceColumns = Lists.newArrayList();
        for (TblColRef tblColRef : inputColumnRowType.getAllColumns()) {
            columns.add(TblColRef.newInnerColumn(tblColRef.getName(), TblColRef.InnerDataTypeEnum.LITERAL));
        }
        for (RelNode child : this.getInputs()) {
            OLAPRel olapChild = (OLAPRel)child;
            List<TblColRef> innerCols = olapChild.getColumnRowType().getAllColumns();
            ArrayList<TupleExpression> children = Lists.newArrayListWithExpectedSize(innerCols.size());
            for (TblColRef innerCol : innerCols) {
                children.add(new ColumnTupleExpression(innerCol));
            }
            sourceColumns.add(new RexCallTupleExpression(DataType.ANY, children));
        }
        ColumnRowType fackColumnRowType = new ColumnRowType(columns, sourceColumns);
        return fackColumnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        for (RelNode child : this.getInputs()) {
            implementor.visitChild(this, child);
        }
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        ArrayList<RelNode> relInputs = new ArrayList<RelNode>(inputs.size());
        for (EnumerableRel input : inputs) {
            if (input instanceof OLAPRel) {
                ((OLAPRel)((Object)input)).replaceTraitSet(EnumerableConvention.INSTANCE);
            }
            relInputs.add(input);
        }
        return new KylinEnumerableUnion(this.getCluster(), this.traitSet.replace(EnumerableConvention.INSTANCE), relInputs, this.all);
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        for (RelNode child : this.getInputs()) {
            if (!((OLAPRel)child).hasSubQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

