/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounterFactory;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class RetentionPartialResult {
    private static final BitmapCounterFactory factory = RoaringBitmapCounterFactory.INSTANCE;
    public static final String FILTER_DELIMETER = KylinConfig.getInstanceFromEnv().getIntersectFilterOrSeparator();
    Map<String, BitmapCounter> map = new LinkedHashMap<String, BitmapCounter>();
    List<String> keyList;
    Map<String, List<String>> childKeyToParentKey;

    public void add(Object key, List keyList, Object value) {
        Preconditions.checkArgument(key != null);
        Preconditions.checkArgument(keyList != null && !keyList.isEmpty());
        if (this.keyList == null) {
            this.keyList = Lists.transform(keyList, i -> i.toString());
            this.childKeyToParentKey = new HashMap<String, List<String>>(5);
            for (String sKey : this.keyList) {
                String[] elements;
                for (String s : elements = StringUtil.splitAndTrim(sKey, FILTER_DELIMETER)) {
                    if (s == null || s.trim().length() <= 0) continue;
                    List parent = this.childKeyToParentKey.computeIfAbsent(s.trim(), o -> new ArrayList());
                    parent.add(sKey);
                }
            }
        }
        if (this.keyList != null) {
            String sKey;
            if (this.keyList.contains(key.toString())) {
                BitmapCounter counter = this.map.computeIfAbsent(key.toString(), o -> factory.newBitmap());
                counter.orWith((BitmapCounter)value);
            }
            if (this.childKeyToParentKey.size() > 0 && this.childKeyToParentKey.containsKey(sKey = key.toString())) {
                List<String> parents = this.childKeyToParentKey.get(sKey);
                for (String parent : parents) {
                    BitmapCounter counter = this.map.computeIfAbsent(parent, o -> factory.newBitmap());
                    counter.orWith((BitmapCounter)value);
                }
            }
        }
    }

    private BitmapCounter result() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            return null;
        }
        for (String key : this.keyList) {
            if (this.map.containsKey(key)) continue;
            return null;
        }
        BitmapCounter counter = null;
        for (String key : this.keyList) {
            BitmapCounter c = this.map.get(key);
            if (counter == null) {
                counter = factory.newBitmap();
                counter.orWith(c);
                continue;
            }
            counter.andWith(c);
        }
        return counter;
    }

    public String valueResult() {
        BitmapCounter counter = this.result();
        String result = "";
        if (counter != null && counter.getCount() > 0L) {
            result = "[" + StringUtils.join(counter.iterator(), ",") + "]";
        }
        return result;
    }

    public long countResult() {
        BitmapCounter counter = this.result();
        return counter != null ? counter.getCount() : 0L;
    }
}

