/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.apache.commons.jocl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ConstructorUtil {
    public static Constructor getConstructor(Class type, Class[] argTypes) {
        if (null == type || null == argTypes) {
            throw new NullPointerException();
        }
        Constructor<Object> ctor = null;
        try {
            ctor = type.getConstructor(argTypes);
        }
        catch (Exception e) {
            ctor = null;
        }
        if (null == ctor) {
            Constructor<?>[] ctors = type.getConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] paramtypes = ctors[i].getParameterTypes();
                if (paramtypes.length != argTypes.length) continue;
                boolean canuse = true;
                for (int j = 0; j < paramtypes.length; ++j) {
                    if (paramtypes[j].isAssignableFrom(argTypes[j])) continue;
                    canuse = false;
                    break;
                }
                if (!canuse) continue;
                ctor = ctors[i];
                break;
            }
        }
        return ctor;
    }

    public static Object invokeConstructor(Class type, Class[] argTypes, Object[] argValues) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return ConstructorUtil.getConstructor(type, argTypes).newInstance(argValues);
    }
}

