/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dict.BytesConverter;

public class Number2BytesConverter
implements BytesConverter<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_DIGITS_BEFORE_DECIMAL_POINT_LEGACY = 16;
    public static final int MAX_DIGITS_BEFORE_DECIMAL_POINT = 19;
    int maxDigitsBeforeDecimalPoint;
    static final transient InternalThreadLocal<Map<Integer, NumberBytesCodec>> LOCAL = new InternalThreadLocal();

    static NumberBytesCodec getCodec(int maxDigitsBeforeDecimalPoint) {
        NumberBytesCodec codec;
        Map<Integer, NumberBytesCodec> codecMap = LOCAL.get();
        if (codecMap == null) {
            codecMap = Maps.newHashMap();
            LOCAL.set(codecMap);
        }
        if ((codec = codecMap.get(maxDigitsBeforeDecimalPoint)) == null) {
            codec = new NumberBytesCodec(maxDigitsBeforeDecimalPoint);
            codecMap.put(maxDigitsBeforeDecimalPoint, codec);
        }
        return codec;
    }

    public Number2BytesConverter() {
        this.maxDigitsBeforeDecimalPoint = 19;
    }

    public Number2BytesConverter(int maxDigitsBeforeDecimalPoint) {
        this.maxDigitsBeforeDecimalPoint = maxDigitsBeforeDecimalPoint;
    }

    public void setMaxDigitsBeforeDecimalPoint(int maxDigitsBeforeDecimalPoint) {
        this.maxDigitsBeforeDecimalPoint = maxDigitsBeforeDecimalPoint;
    }

    @Override
    public byte[] convertToBytes(String v) {
        v = Number2BytesConverter.normalizeNumber(v);
        NumberBytesCodec codec = Number2BytesConverter.getCodec(this.maxDigitsBeforeDecimalPoint);
        byte[] num = Bytes.toBytes(v);
        codec.encodeNumber(num, 0, num.length);
        return Bytes.copy(codec.buf, codec.bufOffset, codec.bufLen);
    }

    public static String normalizeNumber(String v) {
        boolean badBegin;
        boolean bl = badBegin = v.startsWith("0") && v.length() > 1 && v.charAt(1) != '.' || v.startsWith("-0") && v.length() > 2 && v.charAt(2) != '.' || v.startsWith("+");
        if (badBegin) {
            v = new BigDecimal(v).toPlainString();
        }
        while (v.contains(".") && (v.endsWith("0") || v.endsWith("."))) {
            v = v.substring(0, v.length() - 1);
        }
        return v;
    }

    @Override
    public String convertFromBytes(byte[] b, int offset, int length) {
        NumberBytesCodec codec = Number2BytesConverter.getCodec(this.maxDigitsBeforeDecimalPoint);
        byte[] backup = codec.buf;
        codec.buf = b;
        codec.bufOffset = offset;
        codec.bufLen = length;
        int len = codec.decodeNumber(backup, 0);
        codec.buf = backup;
        return Bytes.toString(backup, 0, len);
    }

    @Override
    public byte[] convertBytesValueFromBytes(byte[] b, int offset, int length) {
        NumberBytesCodec codec = Number2BytesConverter.getCodec(this.maxDigitsBeforeDecimalPoint);
        byte[] backup = codec.buf;
        codec.buf = b;
        codec.bufOffset = offset;
        codec.bufLen = length;
        int len = codec.decodeNumber(backup, 0);
        codec.buf = backup;
        byte[] bytes = new byte[len];
        System.arraycopy(backup, 0, bytes, 0, len);
        return bytes;
    }

    static class NumberBytesCodec {
        int maxDigitsBeforeDecimalPoint;
        byte[] buf;
        int bufOffset;
        int bufLen;

        NumberBytesCodec(int maxDigitsBeforeDecimalPoint) {
            this.maxDigitsBeforeDecimalPoint = maxDigitsBeforeDecimalPoint;
            this.buf = new byte[maxDigitsBeforeDecimalPoint * 3];
            this.bufOffset = 0;
            this.bufLen = 0;
        }

        void encodeNumber(byte[] value, int offset, int len) {
            int i;
            int nZeroPadding;
            if (len == 0) {
                this.bufOffset = 0;
                this.bufLen = 0;
                return;
            }
            if (len > this.buf.length) {
                throw new IllegalArgumentException("Too many digits for NumberDictionary: " + Bytes.toString(value, offset, len) + ". Internal buffer is only " + this.buf.length + " bytes");
            }
            boolean negative = value[offset] == 45;
            int start = this.buf.length - len;
            int end = this.buf.length;
            if (negative) {
                --start;
                this.buf[--end] = 59;
            }
            int decimalPoint = end;
            int i2 = start;
            int j = offset;
            while (i2 < end) {
                this.buf[i2] = value[j];
                if (this.buf[i2] == 46 && i2 < decimalPoint) {
                    decimalPoint = i2;
                }
                ++i2;
                ++j;
            }
            if (negative) {
                ++start;
            }
            if ((nZeroPadding = this.maxDigitsBeforeDecimalPoint - (decimalPoint - start)) < 0 || nZeroPadding + 1 > start) {
                throw new IllegalArgumentException("Too many digits for NumberDictionary: " + Bytes.toString(value, offset, len) + ". Expect " + this.maxDigitsBeforeDecimalPoint + " digits before decimal point at max.");
            }
            for (i = 0; i < nZeroPadding; ++i) {
                this.buf[--start] = 48;
            }
            if (negative) {
                this.buf[--start] = 45;
                for (i = start + 1; i < this.buf.length; ++i) {
                    byte c = this.buf[i];
                    if (c < 48 || c > 57) continue;
                    this.buf[i] = (byte)(57 - (c - 48));
                }
            } else {
                this.buf[--start] = 48;
            }
            this.bufOffset = start;
            this.bufLen = this.buf.length - start;
            if (decimalPoint != end) {
                if (negative) {
                    while (this.buf[this.bufOffset + this.bufLen - 2] == 57 && this.bufOffset + this.bufLen - 2 > decimalPoint) {
                        --this.bufLen;
                    }
                    if (this.bufOffset + this.bufLen - 2 == decimalPoint) {
                        --this.bufLen;
                    }
                    this.buf[this.bufOffset + this.bufLen - 1] = 59;
                } else {
                    while (this.buf[this.bufOffset + this.bufLen - 1] == 48 && this.bufOffset + this.bufLen - 1 > decimalPoint) {
                        --this.bufLen;
                    }
                    if (this.bufOffset + this.bufLen - 1 == decimalPoint) {
                        --this.bufLen;
                    }
                }
            }
        }

        int decodeNumber(byte[] returnValue, int offset) {
            boolean negative;
            if (this.bufLen == 0) {
                return 0;
            }
            int in = this.bufOffset;
            int end = this.bufOffset + this.bufLen;
            int out = offset;
            boolean bl = negative = this.buf[in] == 45;
            if (negative) {
                returnValue[out++] = 45;
                ++in;
                --end;
            }
            byte padding = (byte)(negative ? 57 : 48);
            while (in < end && this.buf[in] == padding) {
                ++in;
            }
            if (in == end || this.buf[in] < 48 || this.buf[in] > 57) {
                returnValue[out++] = 48;
            }
            if (negative) {
                while (in < end) {
                    int c = this.buf[in];
                    if (c >= 48 && c <= 57) {
                        c = 57 - (c - 48);
                    }
                    returnValue[out] = (byte)c;
                    ++in;
                    ++out;
                }
            } else {
                System.arraycopy(this.buf, in, returnValue, out, end - in);
                out += end - in;
            }
            return out - offset;
        }
    }
}

