/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class TreeCuboidScheduler
extends CuboidScheduler {
    private final CuboidTree cuboidTree;

    public TreeCuboidScheduler(CubeDesc cubeDesc, List<Long> allCuboidIds, Comparator<Long> cuboidComparator) {
        super(cubeDesc);
        this.cuboidTree = CuboidTree.createFromCuboids(allCuboidIds, cuboidComparator);
    }

    @Override
    public Set<Long> getAllCuboidIds() {
        return this.cuboidTree.getAllCuboidIds();
    }

    @Override
    public int getCuboidCount() {
        return this.cuboidTree.getCuboidCount(Cuboid.getBaseCuboidId(this.cubeDesc));
    }

    @Override
    public List<Long> getSpanningCuboid(long cuboidId) {
        return this.cuboidTree.getSpanningCuboid(cuboidId);
    }

    @Override
    public long findBestMatchCuboid(long cuboidId) {
        return this.cuboidTree.findBestMatchCuboid(cuboidId);
    }

    @Override
    public boolean isValid(long requestCuboid) {
        return this.cuboidTree.isValid(requestCuboid);
    }

    @Override
    public String getCuboidCacheKey() {
        return CubeInstance.class.getSimpleName() + "-" + this.cubeDesc.getName();
    }

    @Override
    public Set<Long> calculateCuboidsForAggGroup(AggregationGroup agg) {
        throw new UnsupportedOperationException();
    }

    public static class CuboidCostComparator
    implements Comparator<Long>,
    Serializable {
        private Map<Long, Long> cuboidStatistics;

        public CuboidCostComparator(Map<Long, Long> cuboidStatistics) {
            Preconditions.checkArgument(cuboidStatistics != null, "the input " + cuboidStatistics + " should not be null!!!");
            this.cuboidStatistics = cuboidStatistics;
        }

        @Override
        public int compare(Long cuboid1, Long cuboid2) {
            Long rowCnt1 = this.cuboidStatistics.get(cuboid1);
            Long rowCnt2 = this.cuboidStatistics.get(cuboid2);
            if (rowCnt2 == null || rowCnt1 == null) {
                return Cuboid.cuboidSelectComparator.compare(cuboid1, cuboid2);
            }
            return Long.compare(rowCnt1, rowCnt2);
        }
    }

    public static class TreeNode
    implements Serializable {
        @JsonProperty(value="cuboid_id")
        long cuboidId;
        @JsonIgnore
        int level;
        @JsonProperty(value="children")
        List<TreeNode> children = Lists.newArrayList();

        public long getCuboidId() {
            return this.cuboidId;
        }

        public int getLevel() {
            return this.level;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        TreeNode(long cuboidId, int level) {
            this.cuboidId = cuboidId;
            this.level = level;
        }

        void addChild(long childId, int parentlevel) {
            this.children.add(new TreeNode(childId, parentlevel + 1));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.cuboidId ^ this.cuboidId >>> 32);
            result = 31 * result + this.level;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TreeNode other = (TreeNode)obj;
            if (this.cuboidId != other.cuboidId) {
                return false;
            }
            return this.level == other.level;
        }
    }

    public static class CuboidTree
    implements Serializable {
        private int treeLevels;
        private TreeNode root;
        private Comparator<Long> cuboidComparator;
        private Map<Long, TreeNode> index = new HashMap<Long, TreeNode>();

        @VisibleForTesting
        static CuboidTree createFromCuboids(List<Long> allCuboidIds) {
            return CuboidTree.createFromCuboids(allCuboidIds, Cuboid.cuboidSelectComparator);
        }

        public static CuboidTree createFromCuboids(List<Long> allCuboidIds, Comparator<Long> cuboidComparator) {
            Collections.sort(allCuboidIds, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return Long.compare(o2, o1);
                }
            });
            long basicCuboidId = allCuboidIds.get(0);
            CuboidTree cuboidTree = new CuboidTree(cuboidComparator);
            cuboidTree.setRoot(basicCuboidId);
            for (long cuboidId : allCuboidIds) {
                cuboidTree.addCuboid(cuboidId);
            }
            cuboidTree.buildIndex();
            return cuboidTree;
        }

        private CuboidTree(Comparator<Long> cuboidComparator) {
            this.cuboidComparator = cuboidComparator;
        }

        public Set<Long> getAllCuboidIds() {
            return this.index.keySet();
        }

        public List<Long> getSpanningCuboid(long cuboidId) {
            TreeNode node = this.index.get(cuboidId);
            if (node == null) {
                throw new IllegalArgumentException("the cuboid:" + cuboidId + " is not exist in the tree");
            }
            ArrayList<Long> result = Lists.newArrayList();
            for (TreeNode child : node.children) {
                result.add(child.cuboidId);
            }
            return result;
        }

        public long findBestMatchCuboid(long cuboidId) {
            if (this.isValid(cuboidId)) {
                return cuboidId;
            }
            return this.findBestParent((long)cuboidId).cuboidId;
        }

        public boolean isValid(long cuboidId) {
            return this.index.containsKey(cuboidId);
        }

        private int getCuboidCount(long cuboidId) {
            int r = 1;
            for (Long child : this.getSpanningCuboid(cuboidId)) {
                r += this.getCuboidCount(child);
            }
            return r;
        }

        public void print(PrintWriter out) {
            int dimensionCnt = Long.bitCount(this.root.cuboidId);
            this.doPrint(this.root, dimensionCnt, 0, out);
        }

        private void doPrint(TreeNode node, int dimensionCount, int depth, PrintWriter out) {
            this.printCuboid(node.cuboidId, dimensionCount, depth, out);
            for (TreeNode child : node.children) {
                this.doPrint(child, dimensionCount, depth + 1, out);
            }
        }

        private void printCuboid(long cuboidID, int dimensionCount, int depth, PrintWriter out) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < depth; ++i) {
                sb.append("    ");
            }
            String cuboidName = Cuboid.getDisplayName(cuboidID, dimensionCount);
            sb.append("|---- Cuboid ").append(cuboidName).append("(" + cuboidID + ")");
            out.println(sb.toString());
        }

        private void setRoot(long basicCuboidId) {
            this.root = new TreeNode(basicCuboidId, 0);
            this.treeLevels = 0;
        }

        private void buildIndex() {
            LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
            queue.add(this.root);
            while (!queue.isEmpty()) {
                TreeNode node = (TreeNode)queue.removeFirst();
                this.index.put(node.cuboidId, node);
                for (TreeNode child : node.children) {
                    queue.add(child);
                }
            }
        }

        private void addCuboid(long cuboidId) {
            TreeNode parent = this.findBestParent(cuboidId);
            if (parent != null && parent.cuboidId != cuboidId) {
                parent.addChild(cuboidId, parent.level);
                this.treeLevels = Math.max(this.treeLevels, parent.level + 1);
            }
        }

        private TreeNode findBestParent(long cuboidId) {
            TreeNode bestParent = this.doFindBestParent(cuboidId, this.root);
            if (bestParent == null) {
                throw new IllegalStateException("Cannot find the parent of the cuboid:" + cuboidId);
            }
            return bestParent;
        }

        private TreeNode doFindBestParent(long cuboidId, TreeNode parentCuboid) {
            if (!this.canDerive(cuboidId, parentCuboid.cuboidId)) {
                return null;
            }
            ArrayList<TreeNode> candidates = Lists.newArrayList();
            for (TreeNode childCuboid : parentCuboid.children) {
                TreeNode candidate = this.doFindBestParent(cuboidId, childCuboid);
                if (candidate == null) continue;
                candidates.add(candidate);
            }
            if (candidates.isEmpty()) {
                candidates.add(parentCuboid);
            }
            return Collections.min(candidates, new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    return cuboidComparator.compare(o1.cuboidId, o2.cuboidId);
                }
            });
        }

        private boolean canDerive(long cuboidId, long parentCuboid) {
            return (cuboidId & (parentCuboid ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
        }
    }
}

