/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import com.yahoo.sketches.tuple.ArrayOfDoublesUpdatableSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesSketchIterator;
import com.yahoo.sketches.tuple.SerializerDeserializer;
import com.yahoo.sketches.tuple.Util;
import java.nio.ByteOrder;

final class DirectArrayOfDoublesCompactSketch
extends ArrayOfDoublesCompactSketch {
    private Memory mem_;

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, Memory dstMem) {
        super(sketch.getNumValues());
        DirectArrayOfDoublesCompactSketch.checkIfEnoughMemory(dstMem, sketch.getRetainedEntries(), sketch.getNumValues());
        this.mem_ = dstMem;
        this.mem_.putByte(0L, (byte)1);
        this.mem_.putByte(1L, (byte)1);
        this.mem_.putByte(2L, (byte)Family.TUPLE.getID());
        this.mem_.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.isEmpty_ = sketch.isEmpty();
        int count = sketch.getRetainedEntries();
        this.mem_.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        this.mem_.putByte(5L, (byte)this.numValues_);
        this.mem_.putShort(6L, Util.computeSeedHash(sketch.getSeed()));
        this.theta_ = sketch.getThetaLong();
        this.mem_.putLong(8L, this.theta_);
        if (count > 0) {
            this.mem_.putInt(16L, sketch.getRetainedEntries());
            int keyOffset = 24;
            int valuesOffset = keyOffset + 8 * sketch.getRetainedEntries();
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            while (it.next()) {
                this.mem_.putLong(keyOffset, it.getKey());
                this.mem_.putDoubleArray(valuesOffset, it.getValues(), 0, this.numValues_);
                keyOffset += 8;
                valuesOffset += 8 * this.numValues_;
            }
        }
    }

    DirectArrayOfDoublesCompactSketch(long[] keys, double[] values, long theta, boolean isEmpty, int numValues, short seedHash, Memory dstMem) {
        super(numValues);
        DirectArrayOfDoublesCompactSketch.checkIfEnoughMemory(dstMem, values.length, numValues);
        this.mem_ = dstMem;
        this.mem_.putByte(0L, (byte)1);
        this.mem_.putByte(1L, (byte)1);
        this.mem_.putByte(2L, (byte)Family.TUPLE.getID());
        this.mem_.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.isEmpty_ = isEmpty;
        int count = keys.length;
        this.mem_.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        this.mem_.putByte(5L, (byte)this.numValues_);
        this.mem_.putShort(6L, seedHash);
        this.theta_ = theta;
        this.mem_.putLong(8L, this.theta_);
        if (count > 0) {
            this.mem_.putInt(16L, count);
            this.mem_.putLongArray(24L, keys, 0, count);
            this.mem_.putDoubleArray(24 + 8 * count, values, 0, values.length);
        }
    }

    DirectArrayOfDoublesCompactSketch(Memory mem) {
        this(mem, 9001L);
    }

    DirectArrayOfDoublesCompactSketch(Memory mem, long seed) {
        super(mem.getByte(5L));
        this.mem_ = mem;
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(this.mem_.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version = this.mem_.getByte(1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        boolean isBigEndian = mem.isAllBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal()));
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        Util.checkSeedHashes(mem.getShort(6L), Util.computeSeedHash(seed));
        this.isEmpty_ = this.mem_.isAnyBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        this.theta_ = this.mem_.getLong(8L);
    }

    @Override
    public int getRetainedEntries() {
        boolean hasEntries = this.mem_.isAnyBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()));
        return hasEntries ? this.mem_.getInt(16L) : 0;
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int valuesOffset = 24 + 8 * count;
            for (int i = 0; i < count; ++i) {
                double[] array = new double[this.numValues_];
                this.mem_.getDoubleArray(valuesOffset, array, 0, this.numValues_);
                values[i] = array;
                valuesOffset += 8 * this.numValues_;
            }
        }
        return values;
    }

    @Override
    public byte[] toByteArray() {
        int count = this.getRetainedEntries();
        int sizeBytes = 16;
        if (count > 0) {
            sizeBytes = 24 + 8 * count + 8 * count * this.numValues_;
        }
        byte[] byteArray = new byte[sizeBytes];
        NativeMemory mem = new NativeMemory(byteArray);
        this.mem_.copy(0L, mem, 0L, sizeBytes);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new DirectArrayOfDoublesSketchIterator(this.mem_, 24, this.getRetainedEntries(), this.numValues_);
    }

    @Override
    short getSeedHash() {
        return this.mem_.getShort(6L);
    }

    private static void checkIfEnoughMemory(Memory mem, int numEntries, int numValues) {
        int sizeNeeded = 24 + (8 + 8 * numValues) * numEntries;
        if ((long)sizeNeeded > mem.getCapacity()) {
            throw new SketchesArgumentException("Not enough memory: need " + sizeNeeded + " bytes, got " + mem.getCapacity() + " bytes");
        }
    }
}

