/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.map.bitmap;

import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMap;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMapFactory;
import org.apache.kylin.measure.map.bitmap.RoaringBitmapCounterMapFactory;

public class BitmapMapAggregator
extends MeasureAggregator<BitmapCounterMap> {
    private static final BitmapCounterMapFactory bitmapFactory = RoaringBitmapCounterMapFactory.INSTANCE;
    private BitmapCounterMap sum;

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void aggregate(BitmapCounterMap value) {
        if (this.sum == null) {
            this.sum = value;
            return;
        }
        this.sum.orWith(value);
    }

    @Override
    public BitmapCounterMap aggregate(BitmapCounterMap value1, BitmapCounterMap value2) {
        BitmapCounterMap merged = bitmapFactory.newBitmapMap();
        if (value1 != null) {
            merged.orWith(value1);
        }
        if (value2 != null) {
            merged.orWith(value2);
        }
        return merged;
    }

    @Override
    public BitmapCounterMap getState() {
        return this.sum;
    }

    @Override
    public int getMemBytesEstimate() {
        return this.sum == null ? 0 : this.sum.getMemBytes();
    }
}

