/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;

public class GTTwoLayerAggregateParam {
    final ImmutableBitSet vanishDimMask;
    final ImmutableBitSet outsideLayerMetrics;
    final String[] outsideLayerMetricsFuncs;
    final int[] insideLayerMetrics;
    final String[] insideLayerMetricsFuncs;
    public static final BytesSerializer<GTTwoLayerAggregateParam> serializer = new BytesSerializer<GTTwoLayerAggregateParam>(){

        @Override
        public void serialize(GTTwoLayerAggregateParam value, ByteBuffer out) {
            if (!value.ifEnabled()) {
                BytesUtil.writeVInt(0, out);
                return;
            }
            BytesUtil.writeVInt(1, out);
            ImmutableBitSet.serializer.serialize(value.vanishDimMask, out);
            ImmutableBitSet.serializer.serialize(value.outsideLayerMetrics, out);
            BytesUtil.writeAsciiStringArray(value.outsideLayerMetricsFuncs, out);
            BytesUtil.writeIntArray(value.insideLayerMetrics, out);
            BytesUtil.writeAsciiStringArray(value.insideLayerMetricsFuncs, out);
        }

        @Override
        public GTTwoLayerAggregateParam deserialize(ByteBuffer in) {
            int ifEnabled = BytesUtil.readVInt(in);
            if (ifEnabled != 1) {
                return new GTTwoLayerAggregateParam();
            }
            ImmutableBitSet vDimMask = ImmutableBitSet.serializer.deserialize(in);
            ImmutableBitSet outLMetrics = ImmutableBitSet.serializer.deserialize(in);
            String[] outLMetricsFuncs = BytesUtil.readAsciiStringArray(in);
            int[] inLMetrics = BytesUtil.readIntArray(in);
            String[] inLMetricsFuncs = BytesUtil.readAsciiStringArray(in);
            return new GTTwoLayerAggregateParam(vDimMask, outLMetrics, outLMetricsFuncs, inLMetrics, inLMetricsFuncs);
        }
    };

    public GTTwoLayerAggregateParam() {
        this.vanishDimMask = new ImmutableBitSet(new BitSet());
        this.outsideLayerMetrics = new ImmutableBitSet(new BitSet());
        this.outsideLayerMetricsFuncs = new String[0];
        this.insideLayerMetrics = new int[0];
        this.insideLayerMetricsFuncs = new String[0];
    }

    public GTTwoLayerAggregateParam(ImmutableBitSet vanishDimMask, ImmutableBitSet outsideLayerMetrics, String[] outsideLayerMetricsFuncs, int[] insideLayerMetrics, String[] insideLayerMetricsFuncs) {
        this.vanishDimMask = vanishDimMask;
        this.outsideLayerMetrics = outsideLayerMetrics;
        this.outsideLayerMetricsFuncs = outsideLayerMetricsFuncs;
        this.insideLayerMetrics = insideLayerMetrics;
        this.insideLayerMetricsFuncs = insideLayerMetricsFuncs;
    }

    public boolean ifEnabled() {
        return this.outsideLayerMetrics != null && this.outsideLayerMetrics.cardinality() > 0;
    }

    public boolean satisfyPrefix(ImmutableBitSet dimMask) {
        for (int i = 0; i < this.vanishDimMask.trueBitCount(); ++i) {
            int c = dimMask.trueBitAt(i);
            if (this.vanishDimMask.get(c)) continue;
            return false;
        }
        return true;
    }
}

