/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;

public class ResponseBodyEmitter {
    private final Long timeout;
    private final Set<DataWithMediaType> earlySendAttempts = new LinkedHashSet<DataWithMediaType>(8);
    private Handler handler;
    private boolean complete;
    private Throwable failure;
    private final DefaultCallback timeoutCallback = new DefaultCallback();
    private final DefaultCallback completionCallback = new DefaultCallback();

    public ResponseBodyEmitter() {
        this.timeout = null;
    }

    public ResponseBodyEmitter(Long timeout) {
        this.timeout = timeout;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    synchronized void initialize(Handler handler) throws IOException {
        this.handler = handler;
        for (DataWithMediaType sendAttempt : this.earlySendAttempts) {
            this.sendInternal(sendAttempt.getData(), sendAttempt.getMediaType());
        }
        this.earlySendAttempts.clear();
        if (this.complete) {
            if (this.failure != null) {
                this.handler.completeWithError(this.failure);
            } else {
                this.handler.complete();
            }
        } else {
            this.handler.onTimeout(this.timeoutCallback);
            this.handler.onCompletion(this.completionCallback);
        }
    }

    protected void extendResponse(ServerHttpResponse outputMessage) {
    }

    public void send(Object object) throws IOException {
        this.send(object, null);
    }

    public synchronized void send(Object object, MediaType mediaType) throws IOException {
        Assert.state(!this.complete, "ResponseBodyEmitter is already set complete");
        this.sendInternal(object, mediaType);
    }

    private void sendInternal(Object object, MediaType mediaType) throws IOException {
        if (object != null) {
            if (this.handler != null) {
                try {
                    this.handler.send(object, mediaType);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to send " + object, ex);
                }
            } else {
                this.earlySendAttempts.add(new DataWithMediaType(object, mediaType));
            }
        }
    }

    public synchronized void complete() {
        this.complete = true;
        if (this.handler != null) {
            this.handler.complete();
        }
    }

    public synchronized void completeWithError(Throwable ex) {
        this.complete = true;
        this.failure = ex;
        if (this.handler != null) {
            this.handler.completeWithError(ex);
        }
    }

    public synchronized void onTimeout(Runnable callback) {
        this.timeoutCallback.setDelegate(callback);
    }

    public synchronized void onCompletion(Runnable callback) {
        this.completionCallback.setDelegate(callback);
    }

    private class DefaultCallback
    implements Runnable {
        private Runnable delegate;

        private DefaultCallback() {
        }

        public void setDelegate(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            ResponseBodyEmitter.this.complete = true;
            if (this.delegate != null) {
                this.delegate.run();
            }
        }
    }

    public static class DataWithMediaType {
        private final Object data;
        private final MediaType mediaType;

        public DataWithMediaType(Object data, MediaType mediaType) {
            this.data = data;
            this.mediaType = mediaType;
        }

        public Object getData() {
            return this.data;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }
    }

    static interface Handler {
        public void send(Object var1, MediaType var2) throws IOException;

        public void complete();

        public void completeWithError(Throwable var1);

        public void onTimeout(Runnable var1);

        public void onCompletion(Runnable var1);
    }
}

