/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;

public class ModelResultMatchers {
    protected ModelResultMatchers() {
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                MatcherAssert.assertThat((String)("Model attribute '" + name + "'"), (Object)mav.getModel().get(name), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher attribute(final String name, final Object value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                AssertionErrors.assertEquals("Model attribute '" + name + "'", value, mav.getModel().get(name));
            }
        };
    }

    public ResultMatcher attributeExists(final String ... names) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                for (String name : names) {
                    AssertionErrors.assertTrue("Model attribute '" + name + "' does not exist", mav.getModel().get(name) != null);
                }
            }
        };
    }

    public ResultMatcher attributeDoesNotExist(final String ... names) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                for (String name : names) {
                    AssertionErrors.assertTrue("Model attribute '" + name + "' exists", mav.getModel().get(name) == null);
                }
            }
        };
    }

    public ResultMatcher attributeErrorCount(final String name, final int expectedCount) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                BindingResult errors = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertEquals("Binding/validation error count for attribute '" + name + "', ", expectedCount, errors.getErrorCount());
            }
        };
    }

    public ResultMatcher attributeHasErrors(final String ... names) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                for (String name : names) {
                    BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                    AssertionErrors.assertTrue("No errors for attribute '" + name + "'", result.hasErrors());
                }
            }
        };
    }

    public ResultMatcher attributeHasNoErrors(final String ... names) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                for (String name : names) {
                    BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                    AssertionErrors.assertTrue("Unexpected errors for attribute '" + name + "': " + result.getAllErrors(), !result.hasErrors());
                }
            }
        };
    }

    public ResultMatcher attributeHasFieldErrors(final String name, final String ... fieldNames) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("No errors for attribute '" + name + "'", result.hasErrors());
                for (String fieldName : fieldNames) {
                    boolean hasFieldErrors = result.hasFieldErrors(fieldName);
                    AssertionErrors.assertTrue("No errors for field '" + fieldName + "' of attribute '" + name + "'", hasFieldErrors);
                }
            }
        };
    }

    public ResultMatcher attributeHasFieldErrorCode(final String name, final String fieldName, final String error) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("No errors for attribute '" + name + "'", result.hasErrors());
                boolean hasFieldErrors = result.hasFieldErrors(fieldName);
                AssertionErrors.assertTrue("No errors for field '" + fieldName + "' of attribute '" + name + "'", hasFieldErrors);
                String code = result.getFieldError(fieldName).getCode();
                AssertionErrors.assertTrue("Expected error code '" + error + "' but got '" + code + "'", code.equals(error));
            }
        };
    }

    public <T> ResultMatcher attributeHasFieldErrorCode(final String name, final String fieldName, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("No errors for attribute: [" + name + "]", result.hasErrors());
                boolean hasFieldErrors = result.hasFieldErrors(fieldName);
                AssertionErrors.assertTrue("No errors for field '" + fieldName + "' of attribute '" + name + "'", hasFieldErrors);
                String code = result.getFieldError(fieldName).getCode();
                MatcherAssert.assertThat((String)("Field name '" + fieldName + "' of attribute '" + name + "'"), (Object)code, (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher errorCount(final int expectedCount) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                int actualCount = ModelResultMatchers.this.getErrorCount(ModelResultMatchers.this.getModelAndView(result).getModelMap());
                AssertionErrors.assertEquals("Binding/validation error count", expectedCount, actualCount);
            }
        };
    }

    public <T> ResultMatcher hasErrors() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                int count = ModelResultMatchers.this.getErrorCount(ModelResultMatchers.this.getModelAndView(result).getModelMap());
                AssertionErrors.assertTrue("Expected binding/validation errors", count != 0);
            }
        };
    }

    public <T> ResultMatcher hasNoErrors() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                for (Object value : mav.getModel().values()) {
                    if (!(value instanceof Errors)) continue;
                    AssertionErrors.assertTrue("Unexpected binding/validation errors: " + value, !((Errors)value).hasErrors());
                }
            }
        };
    }

    public <T> ResultMatcher size(final int size) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                int actual = 0;
                for (String key : mav.getModel().keySet()) {
                    if (key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                    ++actual;
                }
                AssertionErrors.assertEquals("Model size", size, actual);
            }
        };
    }

    private ModelAndView getModelAndView(MvcResult mvcResult) {
        ModelAndView mav = mvcResult.getModelAndView();
        AssertionErrors.assertTrue("No ModelAndView found", mav != null);
        return mav;
    }

    private BindingResult getBindingResult(ModelAndView mav, String name) {
        BindingResult result = (BindingResult)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
        AssertionErrors.assertTrue("No BindingResult for attribute: " + name, result != null);
        return result;
    }

    private int getErrorCount(ModelMap model) {
        int count = 0;
        for (Object value : model.values()) {
            if (!(value instanceof Errors)) continue;
            count += ((Errors)value).getErrorCount();
        }
        return count;
    }
}

