/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.def;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.utils.XmlUtil;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceDefProvider {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceDefProvider.class);
    private static final String RESOURCE_DIR = "datasource";
    private static final String DATASOURCE_DEFAULT = "default";
    private static final DataSourceDefProvider INSTANCE = new DataSourceDefProvider();
    private final Map<String, DataSourceDef> dsCache = Maps.newConcurrentMap();
    private final ClassLoader cl = this.getClass().getClassLoader();

    public static DataSourceDefProvider getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceDef loadDataSourceFromEnv(String id) {
        String resourcePath = "datasource/" + id + ".xml";
        String resourcePathOverride = resourcePath + ".override";
        InputStream is = null;
        try {
            URL url;
            URL urlOverride = this.cl.getResource(resourcePathOverride);
            if (urlOverride == null) {
                url = this.cl.getResource(resourcePath);
            } else {
                url = urlOverride;
                logger.debug("Use override xml:{}", (Object)resourcePathOverride);
            }
            if (url == null) {
                DataSourceDef dataSourceDef = null;
                return dataSourceDef;
            }
            is = url.openStream();
            DataSourceDef ds = XmlUtil.readValue(is, DataSourceDef.class);
            ds.init();
            DataSourceDef dataSourceDef = ds;
            IOUtils.closeQuietly((InputStream)is);
            return dataSourceDef;
        }
        catch (IOException e) {
            logger.error("Failed to load data source: Path={}", (Object)resourcePath, (Object)e);
            DataSourceDef dataSourceDef = null;
            return dataSourceDef;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSourceDef loadDataSourceFromDir(String id) {
        String resourcePath = KylinConfig.getKylinHome() + "/conf/datasource/" + id + ".xml";
        try (FileInputStream is = new FileInputStream(resourcePath);){
            DataSourceDef ds = XmlUtil.readValue(is, DataSourceDef.class);
            ds.init();
            DataSourceDef dataSourceDef = ds;
            return dataSourceDef;
        }
        catch (IOException e) {
            logger.error("[Dev Only] Failed to load data source from directory.: Path={}", (Object)resourcePath, (Object)e.getMessage());
            return null;
        }
    }

    private boolean isDevEnv() {
        return (System.getenv("KYLIN_HOME") != null || System.getProperty("KYLIN_HOME") != null) && KylinConfig.getInstanceFromEnv().isDevEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceDef getById(String id) {
        DataSourceDef devDs;
        if (this.isDevEnv() && (devDs = this.loadDataSourceFromDir(id)) != null) {
            return devDs;
        }
        DataSourceDef ds = this.dsCache.get(id);
        if (ds != null) {
            return ds;
        }
        DataSourceDefProvider dataSourceDefProvider = this;
        synchronized (dataSourceDefProvider) {
            ds = this.dsCache.get(id);
            if (ds == null && (ds = this.loadDataSourceFromEnv(id)) != null) {
                this.dsCache.put(id, ds);
            }
        }
        return ds;
    }

    public DataSourceDef getDefault() {
        return this.getById(DATASOURCE_DEFAULT);
    }
}

