/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.ehcache;

import java.util.concurrent.Callable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.apache.kylin.job.shaded.com.codahale.metrics.Gauge;
import org.apache.kylin.metrics.lib.impl.MetricsSystem;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class InstrumentedEhCacheCache
implements Cache {
    private final Ehcache cache;

    public InstrumentedEhCacheCache(Ehcache ehcache) {
        Assert.notNull(ehcache, "Ehcache must not be null");
        Status status = ehcache.getStatus();
        Assert.isTrue(Status.STATUS_ALIVE.equals(status), "An 'alive' Ehcache is required - current cache is " + status.toString());
        this.cache = ehcache;
        String prefix = MetricsSystem.name(this.cache.getClass(), this.cache.getName());
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "hits"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().cacheHitCount();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "in-memory-hits"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().localHeapHitCount();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "misses"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().cacheMissCount();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "in-memory-misses"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().localHeapMissCount();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "objects"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().getSize();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "in-memory-objects"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().getLocalHeapSize();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "mean-get-time"), new Gauge<Double>(){

            @Override
            public Double getValue() {
                return (Double)InstrumentedEhCacheCache.this.cache.getStatistics().cacheGetOperation().latency().average().value();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "mean-search-time"), new Gauge<Double>(){

            @Override
            public Double getValue() {
                return (Double)InstrumentedEhCacheCache.this.cache.getStatistics().cacheSearchOperation().latency().average().value();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "eviction-count"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return (Long)InstrumentedEhCacheCache.this.cache.getStatistics().cacheEvictionOperation().count().value();
            }
        });
        MetricsSystem.Metrics.register(MetricsSystem.name(prefix, "writer-queue-size"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return InstrumentedEhCacheCache.this.cache.getStatistics().getWriterQueueLength();
            }
        });
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    public Ehcache getNativeCache() {
        return this.cache;
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        Element element = this.cache.get(key);
        return element != null ? new SimpleValueWrapper(element.getObjectValue()) : null;
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(new Element(key, value));
    }

    @Override
    public void evict(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value;
        Element element = this.lookup(key);
        Object object = value = element != null ? element.getObjectValue() : null;
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Object key, Callable<T> valueLoader) {
        Element element = this.lookup(key);
        if (element != null) {
            return (T)element.getObjectValue();
        }
        this.cache.acquireWriteLockOnKey(key);
        try {
            element = this.lookup(key);
            if (element != null) {
                Object object = element.getObjectValue();
                return (T)object;
            }
            T t = this.loadValue(key, valueLoader);
            return t;
        }
        finally {
            this.cache.releaseWriteLockOnKey(key);
        }
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Element existingElement = this.cache.putIfAbsent(new Element(key, value));
        return existingElement != null ? new SimpleValueWrapper(existingElement.getObjectValue()) : null;
    }

    private Element lookup(Object key) {
        return this.cache.get(key);
    }

    private <T> T loadValue(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Throwable ex) {
            throw new Cache.ValueRetrievalException(key, valueLoader, ex);
        }
        this.put(key, value);
        return value;
    }
}

