/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.dict;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.stream.core.dict.StreamingDictionaryClient;

public class StreamingDistributedDictionary
extends Dictionary<String> {
    private ByteArray cubeColumn;
    private transient StreamingDictionaryClient streamingDictionaryClient;

    public StreamingDistributedDictionary(String cubeColumn, StreamingDictionaryClient streamingDictionaryClient) {
        this.streamingDictionaryClient = streamingDictionaryClient;
        this.cubeColumn = new ByteArray(cubeColumn.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int getMinId() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getMaxId() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSizeOfId() {
        return 0;
    }

    @Override
    public int getSizeOfValue() {
        return 0;
    }

    @Override
    public boolean contains(Dictionary<?> another) {
        return false;
    }

    @Override
    protected int getIdFromValueImpl(String value, int roundingFlag) {
        return this.streamingDictionaryClient.encode(this.cubeColumn, value);
    }

    @Override
    protected String getValueFromIdImpl(int id) {
        return "";
    }

    @Override
    public void dump(PrintStream out) {
        throw new UnsupportedOperationException("Do not dump me.");
    }

    @Override
    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("Do not copy me.");
    }

    @Override
    public void readFields(DataInput in) {
        throw new UnsupportedOperationException("Do not read me.");
    }
}

