/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.storage.gtrecord.PeekingImpl;
import org.apache.kylin.storage.gtrecord.SortedIteratorMerger;

public class SortedIteratorMergerWithLimit<E extends Cloneable>
extends SortedIteratorMerger<E> {
    private int limit;

    public SortedIteratorMergerWithLimit(Iterator<Iterator<E>> shardSubsets, int limit, Comparator<E> comparator) {
        super(shardSubsets, comparator);
        this.limit = limit;
        this.comparator = comparator;
    }

    @Override
    public Iterator<E> getIterator() {
        return new MergedIteratorWithLimit(this.limit, this.comparator);
    }

    class MergedIteratorWithLimit
    implements Iterator<E> {
        private PriorityQueue<PeekingImpl<E>> heap;
        private final Comparator<E> comparator;
        private boolean nextFetched = false;
        private E fetched = null;
        private E last = null;
        private int limit;
        private int limitProgress = 0;
        private PeekingImpl<E> lastSource = null;

        public MergedIteratorWithLimit(int limit, Comparator<E> comparator) {
            this.limit = limit;
            this.comparator = comparator;
        }

        @Override
        public boolean hasNext() {
            if (this.heap == null) {
                this.heap = SortedIteratorMergerWithLimit.this.getHeap();
            }
            if (this.nextFetched) {
                return true;
            }
            if (this.lastSource != null && this.lastSource.hasNext()) {
                if (this.lastSource.hasNext()) {
                    this.heap.offer(this.lastSource);
                } else {
                    this.lastSource = null;
                }
            }
            if (!this.heap.isEmpty()) {
                PeekingImpl first = this.heap.poll();
                Cloneable current = (Cloneable)first.next();
                try {
                    current = (Cloneable)current.getClass().getMethod("clone", new Class[0]).invoke((Object)current, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                this.lastSource = first;
                Preconditions.checkState(current != null);
                if ((this.last == null || this.comparator.compare(current, this.last) != 0) && ++this.limitProgress > this.limit) {
                    return false;
                }
                this.nextFetched = true;
                this.fetched = current;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.nextFetched) {
                throw new NoSuchElementException("Should hasNext() before next()");
            }
            if (this.last != null && this.comparator.compare(this.last, this.fetched) > 0) {
                throw new IllegalStateException("Not sorted! last: " + this.last + " fetched: " + this.fetched);
            }
            this.last = this.fetched;
            this.nextFetched = false;
            return this.fetched;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

