/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.IInput;
import org.apache.kylin.engine.spark.ISparkInput;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.source.kafka.KafkaInputBase;

public class KafkaSparkInput
extends KafkaInputBase
implements ISparkInput {
    private CubeSegment cubeSegment;

    @Override
    public IInput.IBatchCubingInputSide getBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
        this.cubeSegment = (CubeSegment)flatDesc.getSegment();
        return new KafkaSparkBatchCubingInputSide(this.cubeSegment, flatDesc);
    }

    @Override
    public IInput.IBatchMergeInputSide getBatchMergeInputSide(ISegment seg) {
        return new KafkaSparkBatchMergeInputSide((CubeSegment)seg);
    }

    public static class KafkaSparkBatchMergeInputSide
    extends KafkaInputBase.BaseBatchMergeInputSide
    implements ISparkInput.ISparkBatchMergeInputSide {
        KafkaSparkBatchMergeInputSide(CubeSegment cubeSegment) {
            super(cubeSegment);
        }
    }

    public static class KafkaSparkBatchCubingInputSide
    extends KafkaInputBase.BaseBatchCubingInputSide
    implements ISparkInput.ISparkBatchCubingInputSide {
        public KafkaSparkBatchCubingInputSide(CubeSegment seg, IJoinedFlatTableDesc flatDesc) {
            super(seg, flatDesc);
        }
    }
}

