/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.engine.flink.IFlinkInput;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.hive.GarbageCollectionStep;
import org.apache.kylin.source.hive.HiveInputBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveFlinkInput
extends HiveInputBase
implements IFlinkInput {
    private static final Logger logger = LoggerFactory.getLogger(HiveFlinkInput.class);

    @Override
    public IFlinkInput.IFlinkBatchCubingInputSide getBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
        return new BatchCubingInputSide(flatDesc);
    }

    @Override
    public IFlinkInput.IFlinkBatchMergeInputSide getBatchMergeInputSide(ISegment seg) {
        return new IFlinkInput.IFlinkBatchMergeInputSide(){

            @Override
            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
            }
        };
    }

    public class BatchCubingInputSide
    extends HiveInputBase.BaseBatchCubingInputSide
    implements IFlinkInput.IFlinkBatchCubingInputSide {
        List<String> hiveViewIntermediateTables;

        public BatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
            super(flatDesc);
            this.hiveViewIntermediateTables = Lists.newArrayList();
        }

        @Override
        protected void addStepPhase1_DoMaterializeLookupTable(DefaultChainedExecutable jobFlow) {
            String jobWorkingDir;
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            ShellExecutable task = HiveInputBase.createLookupHiveViewMaterializationStep(hiveInitStatements, jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir), this.flatDesc, this.hiveViewIntermediateTables, jobFlow.getId());
            if (task != null) {
                jobFlow.addTask(task);
            }
        }

        @Override
        public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
            String jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            GarbageCollectionStep step = new GarbageCollectionStep();
            step.setName("Hive Cleanup");
            step.setIntermediateTables(Collections.singletonList(this.getIntermediateTableIdentity()));
            step.setExternalDataPaths(Collections.singletonList(JoinedFlatTable.getTableDir(this.flatDesc, jobWorkingDir)));
            step.setHiveViewIntermediateTableIdentities(StringUtil.join(this.hiveViewIntermediateTables, ","));
            jobFlow.addTask(step);
        }
    }
}

