/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class CubeInstanceResponse
extends CubeInstance {
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="is_streaming")
    private boolean isStreaming;
    @JsonProperty(value="partitionDateColumn")
    private String partitionDateColumn;
    @JsonProperty(value="partitionDateStart")
    private long partitionDateStart;
    @JsonProperty(value="isStandardPartitioned")
    private boolean isStandardPartitioned;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records_count")
    private long inputRecordCnt;
    @JsonProperty(value="input_records_size")
    private long inputRecordSizeBytes;

    public CubeInstanceResponse(CubeInstance cube, String project) {
        this.project = project;
        if (cube == null) {
            return;
        }
        this.setUuid(cube.getUuid());
        this.setVersion(cube.getVersion());
        this.setName(cube.getName());
        this.setOwner(cube.getOwner());
        this.setDescName(cube.getDescName());
        this.setCost(cube.getCost());
        this.setStatus(cube.getStatus());
        this.setSegments(cube.getSegments());
        this.setCreateTimeUTC(cube.getCreateTimeUTC());
        this.setLastModified(cube.getDescriptor().getLastModified());
        this.setCuboidLastOptimized(cube.getCuboidLastOptimized());
        this.model = cube.getDescriptor().getModelName();
        this.partitionDateStart = cube.getDescriptor().getPartitionDateStart();
        if (cube.getModel() != null) {
            this.partitionDateColumn = cube.getModel().getPartitionDesc().getPartitionDateColumn();
            this.isStandardPartitioned = cube.getModel().isStandardPartitionedDateColumn();
            this.isStreaming = cube.getModel().getRootFactTable().getTableDesc().getSourceType() == 1;
        }
        this.initSizeKB();
        this.initInputRecordCount();
        this.initInputRecordSizeBytes();
    }

    protected void setModel(String model) {
        this.model = model;
    }

    protected void initSizeKB() {
        this.sizeKB = super.getSizeKB();
    }

    protected void initInputRecordCount() {
        this.inputRecordCnt = super.getInputRecordCount();
    }

    protected void initInputRecordSizeBytes() {
        this.inputRecordSizeBytes = super.getInputRecordSizeBytes();
    }
}

