/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.JobListRequest;
import org.apache.kylin.rest.service.JobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jobs"})
public class JobController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(JobController.class);
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<JobInstance> list(JobListRequest jobRequest) {
        List<JobInstance> jobInstanceList;
        ArrayList<JobStatusEnum> statusList = new ArrayList<JobStatusEnum>();
        if (null != jobRequest.getStatus()) {
            for (int status : jobRequest.getStatus()) {
                statusList.add(JobStatusEnum.getByCode(status));
            }
        }
        JobTimeFilterEnum timeFilter = null;
        timeFilter = null != jobRequest.getTimeFilter() ? JobTimeFilterEnum.getByCode(jobRequest.getTimeFilter()) : JobTimeFilterEnum.getByCode(KylinConfig.getInstanceFromEnv().getDefaultTimeFilter());
        JobService.JobSearchMode jobSearchMode = JobService.JobSearchMode.CUBING_ONLY;
        if (null != jobRequest.getJobSearchMode()) {
            try {
                jobSearchMode = JobService.JobSearchMode.valueOf(jobRequest.getJobSearchMode());
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid value for JobSearchMode: '" + jobRequest.getJobSearchMode() + "', skip it.");
            }
        }
        try {
            jobInstanceList = this.jobService.searchJobsV2(jobRequest.getCubeName(), jobRequest.getProjectName(), statusList, jobRequest.getLimit(), jobRequest.getOffset(), timeFilter, jobSearchMode);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
        return jobInstanceList;
    }

    @RequestMapping(value={"/overview"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<JobStatusEnum, Integer> jobOverview(JobListRequest jobRequest) {
        HashMap<JobStatusEnum, Integer> jobOverview = new HashMap();
        ArrayList<JobStatusEnum> statusList = new ArrayList<JobStatusEnum>();
        if (null != jobRequest.getStatus()) {
            for (int status : jobRequest.getStatus()) {
                statusList.add(JobStatusEnum.getByCode(status));
            }
        }
        JobTimeFilterEnum timeFilter = JobTimeFilterEnum.LAST_ONE_WEEK;
        if (null != jobRequest.getTimeFilter()) {
            timeFilter = JobTimeFilterEnum.getByCode(jobRequest.getTimeFilter());
        }
        JobService.JobSearchMode jobSearchMode = JobService.JobSearchMode.CUBING_ONLY;
        if (null != jobRequest.getJobSearchMode()) {
            try {
                jobSearchMode = JobService.JobSearchMode.valueOf(jobRequest.getJobSearchMode());
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid value for JobSearchMode: '" + jobRequest.getJobSearchMode() + "', skip it.");
            }
        }
        try {
            jobOverview = this.jobService.searchJobsOverview(jobRequest.getCubeName(), jobRequest.getProjectName(), statusList, timeFilter, jobSearchMode);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
        return jobOverview;
    }

    @RequestMapping(value={"/{jobId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JobInstance get(@PathVariable String jobId) {
        JobInstance jobInstance = null;
        try {
            jobInstance = this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
        return jobInstance;
    }

    @RequestMapping(value={"/{jobId}/steps/{stepId}/output"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getStepOutput(@PathVariable String jobId, @PathVariable String stepId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("jobId", jobId);
        result.put("stepId", String.valueOf(stepId));
        result.put("cmd_output", this.jobService.getExecutableManager().getOutput(stepId).getVerboseMsg());
        return result;
    }

    @RequestMapping(value={"/{jobId}/resume"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance resume(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            if (jobInstance == null) {
                throw new BadRequestException("Cannot find job: " + jobId);
            }
            this.jobService.resumeJob(jobInstance);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/resubmit"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void resubmitJob(@PathVariable String jobId) throws IOException {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            if (jobInstance == null) {
                throw new BadRequestException("Cannot find job: " + jobId);
            }
            this.jobService.resubmitJob(jobInstance);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw e;
        }
    }

    @RequestMapping(value={"/{jobId}/cancel"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance cancel(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            if (jobInstance == null) {
                throw new BadRequestException("Cannot find job: " + jobId);
            }
            this.jobService.cancelJob(jobInstance);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/pause"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance pause(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            if (jobInstance == null) {
                throw new BadRequestException("Cannot find job: " + jobId);
            }
            this.jobService.pauseJob(jobInstance);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/steps/{stepId}/rollback"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance rollback(@PathVariable String jobId, @PathVariable String stepId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            if (jobInstance == null) {
                throw new BadRequestException("Cannot find job: " + jobId);
            }
            this.jobService.rollbackJob(jobInstance, stepId);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/drop"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public JobInstance dropJob(@PathVariable String jobId) {
        JobInstance jobInstance = null;
        try {
            jobInstance = this.jobService.getJobInstance(jobId);
            if (jobInstance == null) {
                throw new BadRequestException("Cannot find job: " + jobId);
            }
            this.jobService.dropJob(jobInstance);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e);
        }
        return jobInstance;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

