/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPSchema
extends AbstractSchema {
    private KylinConfig config;
    private String projectName;
    private String schemaName;
    private boolean exposeMore;
    private StorageURL storageUrl;
    private String starSchemaUrl;
    private String starSchemaUser;
    private String starSchemaPassword;

    private void init() {
        this.config = KylinConfig.getInstanceFromEnv();
        this.storageUrl = this.config.getStorageUrl();
        this.starSchemaUrl = this.config.getHiveUrl();
        this.starSchemaUser = this.config.getHiveUser();
        this.starSchemaPassword = this.config.getHivePassword();
    }

    public OLAPSchema(String project, String schemaName, boolean exposeMore) {
        this.projectName = project;
        this.schemaName = schemaName;
        this.exposeMore = exposeMore;
        this.init();
    }

    public Map<String, Table> getTableMap() {
        return this.buildTableMap();
    }

    private Map<String, Table> buildTableMap() {
        HashMap<String, Table> olapTables = new HashMap<String, Table>();
        Collection<TableDesc> projectTables = ProjectManager.getInstance(this.config).listExposedTables(this.projectName, this.exposeMore);
        for (TableDesc tableDesc : projectTables) {
            if (!tableDesc.getDatabase().equals(this.schemaName)) continue;
            String tableName = tableDesc.getName();
            OLAPTable table = new OLAPTable(this, tableDesc, this.exposeMore);
            olapTables.put(tableName, (Table)table);
        }
        return olapTables;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public StorageURL getStorageUrl() {
        return this.storageUrl;
    }

    public boolean hasStarSchemaUrl() {
        return this.starSchemaUrl != null && !this.starSchemaUrl.isEmpty();
    }

    public String getStarSchemaUrl() {
        return this.starSchemaUrl;
    }

    public String getStarSchemaUser() {
        return this.starSchemaUser;
    }

    public String getStarSchemaPassword() {
        return this.starSchemaPassword;
    }

    public DataModelManager getMetadataManager() {
        return DataModelManager.getInstance(this.config);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance(this.config);
    }

    public ProjectInstance getProjectInstance() {
        return ProjectManager.getInstance(this.config).getProject(this.projectName);
    }
}

