/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;

public class MeasureAggregators
implements Serializable {
    private final MeasureAggregator[] aggs;
    private final int descLength;

    public MeasureAggregators(MeasureAggregator ... aggs) {
        this.descLength = aggs.length;
        this.aggs = aggs;
    }

    public MeasureAggregators(Collection<MeasureDesc> measureDescs) {
        this(measureDescs.toArray(new MeasureDesc[measureDescs.size()]));
    }

    public MeasureAggregators(MeasureDesc ... measureDescs) {
        int i;
        this.descLength = measureDescs.length;
        this.aggs = new MeasureAggregator[this.descLength];
        HashMap<String, Integer> measureIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < this.descLength; ++i) {
            FunctionDesc func = measureDescs[i].getFunction();
            this.aggs[i] = func.getMeasureType().newAggregator();
            measureIndexMap.put(measureDescs[i].getName(), i);
        }
        for (i = 0; i < this.descLength; ++i) {
            String depMsrRef = measureDescs[i].getDependentMeasureRef();
            if (depMsrRef == null) continue;
            int index = (Integer)measureIndexMap.get(depMsrRef);
            this.aggs[i].setDependentAggregator(this.aggs[index]);
        }
    }

    public void reset() {
        for (int i = 0; i < this.aggs.length; ++i) {
            this.aggs[i].reset();
        }
    }

    public void aggregate(Object[] values) {
        assert (values.length == this.descLength);
        for (int i = 0; i < this.descLength; ++i) {
            this.aggs[i].aggregate(values[i]);
        }
    }

    public void aggregate(Object[] values, int[] measures) {
        assert (values.length == this.descLength);
        for (int i = 0; i < measures.length; ++i) {
            this.aggs[measures[i]].aggregate(values[measures[i]]);
        }
    }

    public void aggregate(Object[] values1, Object[] values2, Object[] result) {
        assert (values1.length == values2.length && values2.length == this.descLength && values1.length == result.length);
        for (int i = 0; i < this.descLength; ++i) {
            result[i] = this.aggs[i].aggregate(values1[i], values2[i]);
        }
    }

    public void aggregate(Object[] values1, Object[] values2, Object[] result, boolean[] aggrMask) {
        assert (values1.length == values2.length && values2.length == this.descLength && values1.length == result.length && result.length == aggrMask.length);
        for (int i = 0; i < this.descLength; ++i) {
            if (!aggrMask[i]) continue;
            result[i] = this.aggs[i].aggregate(values1[i], values2[i]);
        }
    }

    public void collectStates(Object[] states) {
        for (int i = 0; i < this.descLength; ++i) {
            states[i] = this.aggs[i].getState();
        }
    }
}

