/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.Serializable;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerTaskEnd;

public class KylinSparkJobListener
extends SparkListener
implements Serializable {
    public JobMetrics metrics = new JobMetrics();

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        if (taskEnd != null && taskEnd.taskMetrics() != null && taskEnd.taskMetrics().outputMetrics() != null) {
            this.metrics.bytesWritten += taskEnd.taskMetrics().outputMetrics().bytesWritten();
            this.metrics.recordsWritten += taskEnd.taskMetrics().outputMetrics().recordsWritten();
        }
    }

    public JobMetrics getMetrics() {
        return this.metrics;
    }

    public static class JobMetrics
    implements Serializable {
        long bytesWritten;
        long recordsWritten;

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public long getRecordsWritten() {
            return this.recordsWritten;
        }
    }
}

