/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="The ApiParcelState encapsulates the state of a parcel while it is in transition and reports any errors that may have occurred.. <p> The complete progress of a parcel is broken up into two different reporting indicators - progress and count. Progress is the primary indicator that reports the global state of transitions. For example, when downloading, progress and totalProgress will show the current number of bytes downloaded and the total number of bytes needed to be downloaded respectively. </p> <p> The count and totalCount indicator is used when a state transition affects multiple hosts. The count and totalCount show the current number of hosts completed and the total number of hosts respectively. For example, during distribution, the progress and totalProgress will show how many bytes have been transferred to each host and the count will indicate how many hosts of of totalCount have had parcels unpacked. </p> <p> Along with the two progress indicators, the ApiParcelState shows both errors and warnings that may have turned up during a state transition. </p>")
public class ApiParcelState {
    @SerializedName(value="progress")
    private BigDecimal progress = null;
    @SerializedName(value="totalProgress")
    private BigDecimal totalProgress = null;
    @SerializedName(value="count")
    private BigDecimal count = null;
    @SerializedName(value="totalCount")
    private BigDecimal totalCount = null;
    @SerializedName(value="errors")
    private List<String> errors = null;
    @SerializedName(value="warnings")
    private List<String> warnings = null;

    public ApiParcelState progress(BigDecimal progress) {
        this.progress = progress;
        return this;
    }

    @Schema(description="The progress of the state transition.")
    public BigDecimal getProgress() {
        return this.progress;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public ApiParcelState totalProgress(BigDecimal totalProgress) {
        this.totalProgress = totalProgress;
        return this;
    }

    @Schema(description="The total amount that #getProgress() needs to get to.")
    public BigDecimal getTotalProgress() {
        return this.totalProgress;
    }

    public void setTotalProgress(BigDecimal totalProgress) {
        this.totalProgress = totalProgress;
    }

    public ApiParcelState count(BigDecimal count) {
        this.count = count;
        return this;
    }

    @Schema(description="The current hosts that have completed.")
    public BigDecimal getCount() {
        return this.count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public ApiParcelState totalCount(BigDecimal totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Schema(description="The total amount that #getCount() needs to get to.")
    public BigDecimal getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(BigDecimal totalCount) {
        this.totalCount = totalCount;
    }

    public ApiParcelState errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public ApiParcelState addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Schema(description="The errors that exist for this parcel.")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public ApiParcelState warnings(List<String> warnings) {
        this.warnings = warnings;
        return this;
    }

    public ApiParcelState addWarningsItem(String warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Schema(description="The warnings that exist for this parcel.")
    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiParcelState apiParcelState = (ApiParcelState)o;
        return Objects.equals(this.progress, apiParcelState.progress) && Objects.equals(this.totalProgress, apiParcelState.totalProgress) && Objects.equals(this.count, apiParcelState.count) && Objects.equals(this.totalCount, apiParcelState.totalCount) && Objects.equals(this.errors, apiParcelState.errors) && Objects.equals(this.warnings, apiParcelState.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.progress, this.totalProgress, this.count, this.totalCount, this.errors, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiParcelState {\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    totalProgress: ").append(this.toIndentedString(this.totalProgress)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

