/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHiveReplicationArguments;
import com.cloudera.api.swagger.model.ReplicationOption;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Replication arguments for Hive services.")
public class ApiHiveCloudReplicationArguments
extends ApiHiveReplicationArguments {
    @SerializedName(value="exportFilesPrefix")
    private String exportFilesPrefix = null;
    @SerializedName(value="sourceAccount")
    private String sourceAccount = null;
    @SerializedName(value="destinationAccount")
    private String destinationAccount = null;
    @SerializedName(value="cloudRootPath")
    private String cloudRootPath = null;
    @SerializedName(value="replicationOption")
    private ReplicationOption replicationOption = null;

    public ApiHiveCloudReplicationArguments exportFilesPrefix(String exportFilesPrefix) {
        this.exportFilesPrefix = exportFilesPrefix;
        return this;
    }

    @Schema(description="When a Hive external cloud replication schedule was executed, then the exported files had the same name under the given cloud root path. Therefore, it was forbidden to concurrently execute multiple Hive external replications with the same cloud root path. <br>  This field is meant to lift this restriction: it contains a prefix name that will be prepended to every export file, by default it is set to a UUID for a replication schedule. <br>  <b>Note that this feature is available only if feature flag HIVE_ALLOW_CONCURRENT_REPLICATION_WITH_SAME_CLOUD_ROOT_PATH is enabled on both source and destination! It's NOT supported for cloud backup only and cloud restore only replications.</b> <br>  For instance if #cloudRootPath == s3a://bucket/warehouse/external/my_db and #exportFilesPrefix == ab58c108, then after a successful replication the following export files will be in the cloud: <ul> <li>s3a://bucket/warehouse/external/my_db/ab58c108export.json</li> <li>s3a://bucket/warehouse/external/my_db/ab58c108.export.json.meta</li> <li>s3a://bucket/warehouse/external/my_db/ab58c108sentry-export.json</li> </ul> In the next replication run the same UUID will be used for a certain schedule as before, so the same export files will be overwritten in the cloud. This way the cloud root path won't be polluted.")
    public String getExportFilesPrefix() {
        return this.exportFilesPrefix;
    }

    public void setExportFilesPrefix(String exportFilesPrefix) {
        this.exportFilesPrefix = exportFilesPrefix;
    }

    public ApiHiveCloudReplicationArguments sourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @Schema(description="")
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public ApiHiveCloudReplicationArguments destinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    @Schema(description="")
    public String getDestinationAccount() {
        return this.destinationAccount;
    }

    public void setDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public ApiHiveCloudReplicationArguments cloudRootPath(String cloudRootPath) {
        this.cloudRootPath = cloudRootPath;
        return this;
    }

    @Schema(description="")
    public String getCloudRootPath() {
        return this.cloudRootPath;
    }

    public void setCloudRootPath(String cloudRootPath) {
        this.cloudRootPath = cloudRootPath;
    }

    public ApiHiveCloudReplicationArguments replicationOption(ReplicationOption replicationOption) {
        this.replicationOption = replicationOption;
        return this;
    }

    @Schema(description="")
    public ReplicationOption getReplicationOption() {
        return this.replicationOption;
    }

    public void setReplicationOption(ReplicationOption replicationOption) {
        this.replicationOption = replicationOption;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHiveCloudReplicationArguments apiHiveCloudReplicationArguments = (ApiHiveCloudReplicationArguments)o;
        return Objects.equals(this.exportFilesPrefix, apiHiveCloudReplicationArguments.exportFilesPrefix) && Objects.equals(this.sourceAccount, apiHiveCloudReplicationArguments.sourceAccount) && Objects.equals(this.destinationAccount, apiHiveCloudReplicationArguments.destinationAccount) && Objects.equals(this.cloudRootPath, apiHiveCloudReplicationArguments.cloudRootPath) && Objects.equals((Object)this.replicationOption, (Object)apiHiveCloudReplicationArguments.replicationOption) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.exportFilesPrefix, this.sourceAccount, this.destinationAccount, this.cloudRootPath, this.replicationOption, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHiveCloudReplicationArguments {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    exportFilesPrefix: ").append(this.toIndentedString(this.exportFilesPrefix)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    destinationAccount: ").append(this.toIndentedString(this.destinationAccount)).append("\n");
        sb.append("    cloudRootPath: ").append(this.toIndentedString(this.cloudRootPath)).append("\n");
        sb.append("    replicationOption: ").append(this.toIndentedString((Object)this.replicationOption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

