/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Cas30ServiceTicketValidator
extends Cas20ServiceTicketValidator {
    public Cas30ServiceTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    @Override
    protected String getUrlSuffix() {
        return "p3/serviceValidate";
    }

    @Override
    protected Map<String, Object> extractCustomAttributes(String xml) {
        Document document = XmlUtils.newDocument(xml);
        NodeList attributeList = document.getElementsByTagName("cas:attribute");
        if (attributeList.getLength() == 0) {
            return super.extractCustomAttributes(xml);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (int i = 0; i < attributeList.getLength(); ++i) {
            Node casAttributeNode = attributeList.item(i);
            NamedNodeMap nodeAttributes = casAttributeNode.getAttributes();
            String name = nodeAttributes.getNamedItem("name").getNodeValue();
            String value = nodeAttributes.getNamedItem("value").getTextContent();
            Object mapValue = attributes.get(name);
            if (mapValue != null) {
                if (mapValue instanceof List) {
                    ((List)mapValue).add(value);
                    continue;
                }
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(mapValue);
                list.add(value);
                attributes.put(name, list);
                continue;
            }
            attributes.put(name, value);
        }
        return attributes;
    }
}

