/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class UrlEncodedFormRequest
extends HttpServletRequestWrapper {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final MultiMap<String> queryParams;

    public UrlEncodedFormRequest(HttpServletRequest request) throws IOException {
        super(request);
        LOG.wrappingRequestToUrlEncodedFormRequest(request.getRequestURI());
        this.queryParams = this.parseQueryString(request.getQueryString());
    }

    public static boolean isUrlEncodedForm(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    private MultiMap<String> parseQueryString(String queryString) {
        MultiMap params = new MultiMap();
        if (queryString != null) {
            UrlEncoded.decodeTo((String)queryString, (MultiMap)params, (String)this.getCharacterEncoding());
        }
        return params;
    }

    public String getParameter(String name) {
        return (String)this.queryParams.getValue(name, 0);
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.queryParams.toStringArrayMap();
    }

    public Enumeration<String> getParameterNames() {
        final Iterator iterator = this.queryParams.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }
}

