/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.client;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

class OffsetDateTimeTypeAdapter
extends TypeAdapter<OffsetDateTime> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    OffsetDateTimeTypeAdapter() {
    }

    public void write(JsonWriter out, OffsetDateTime date) throws IOException {
        if (date == null) {
            out.nullValue();
        } else {
            out.value(this.formatter.format(date));
        }
    }

    public OffsetDateTime read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        String date = in.nextString();
        if (date.endsWith("+0000")) {
            date = date.substring(0, date.length() - 5) + "Z";
        }
        return OffsetDateTime.parse(date, this.formatter);
    }
}

