/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableCallHistory;
import org.apache.knox.gateway.shell.table.KnoxShellTableFileUtils;
import org.apache.knox.gateway.util.JsonUtils;

class KnoxShellTableJSONSerializer {
    static final ThreadLocal<DateFormat> JSON_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault()));

    KnoxShellTableJSONSerializer() {
    }

    static String serializeKnoxShellTable(KnoxShellTable table, boolean data, String filePath) {
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            return KnoxShellTableJSONSerializer.saveTableInFile(table, data, filePath);
        }
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        if (data) {
            filterProvider.addFilter("knoxShellTableFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"headers", "rows", "title", "id"}));
        } else {
            filterProvider.addFilter("knoxShellTableFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"callHistoryList"}));
        }
        return JsonUtils.renderAsJsonString((Object)table, (FilterProvider)filterProvider, (DateFormat)JSON_DATE_FORMAT.get());
    }

    private static String saveTableInFile(KnoxShellTable table, boolean data, String filePath) {
        try {
            String jsonResult;
            if (data) {
                SimpleFilterProvider filterProvider = new SimpleFilterProvider();
                filterProvider.addFilter("knoxShellTableFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"headers", "rows", "title", "id"}));
                jsonResult = JsonUtils.renderAsJsonString((Object)table, (FilterProvider)filterProvider, (DateFormat)JSON_DATE_FORMAT.get());
            } else {
                jsonResult = JsonUtils.renderAsJsonString(KnoxShellTableCallHistory.getInstance().getCallHistory(table.id), null, (DateFormat)JSON_DATE_FORMAT.get());
            }
            KnoxShellTableFileUtils.persistToFile(filePath, jsonResult);
            return "Successfully saved into " + filePath;
        }
        catch (IOException e) {
            throw new KnoxShellException("Error while saving KnoxShellTable JSON into " + filePath, e);
        }
    }
}

