/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.advanced;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class AdvancedServiceDiscoveryConfig {
    public static final String PARAMETER_NAME_PREFIX_ENABLED_SERVICE = "gateway.auto.discovery.";
    public static final String PARAMETER_NAME_POSTFIX_ENABLED_SERVICE = ".enabled.";
    public static final String PARAMETER_NAME_TOPOLOGY_NAME = "gateway.auto.discovery.topology.name";
    public static final String PARAMETER_NAME_DISCOVERY_ADDRESS = "gateway.auto.discovery.address";
    public static final String PARAMETER_NAME_DISCOVERY_CLUSTER = "gateway.auto.discovery.cluster";
    private final Properties properties;

    public AdvancedServiceDiscoveryConfig() {
        this(null);
    }

    public AdvancedServiceDiscoveryConfig(Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
    }

    public boolean isServiceEnabled(String serviceName) {
        String propertyName = PARAMETER_NAME_PREFIX_ENABLED_SERVICE + this.getTopologyName() + PARAMETER_NAME_POSTFIX_ENABLED_SERVICE + serviceName;
        return Boolean.valueOf(this.getPropertyIgnoreCase(propertyName, "true"));
    }

    public Set<String> getEnabledServiceNames() {
        return this.properties.entrySet().stream().filter(keyValuePair -> Boolean.valueOf((String)keyValuePair.getValue())).map(keyValuePair -> ((String)keyValuePair.getKey()).substring(((String)keyValuePair.getKey()).lastIndexOf(46) + 1).toUpperCase(Locale.getDefault())).collect(Collectors.toSet());
    }

    public String getTopologyName() {
        return this.getPropertyIgnoreCase(PARAMETER_NAME_TOPOLOGY_NAME, "");
    }

    public String getDiscoveryAddress() {
        return this.getPropertyIgnoreCase(PARAMETER_NAME_DISCOVERY_ADDRESS, "");
    }

    public String getDiscoveryCluster() {
        return this.getPropertyIgnoreCase(PARAMETER_NAME_DISCOVERY_CLUSTER, "");
    }

    private String getPropertyIgnoreCase(String propertyName, String defaultValue) {
        String property = this.properties.getProperty(propertyName);
        if (property != null) {
            return property;
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (!propertyName.equalsIgnoreCase((String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return defaultValue;
    }

    public String toString() {
        return this.properties.toString();
    }
}

