/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ValidationState;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Model for a configuration parameter.  When an entry's <i>value</i> property is not available, it means the entry is not configured. This means that the default value for the entry, if any, will be used. Setting a value to <i>null</i> also can be used to unset any previously set value for the parameter, reverting to the default value (if any).")
public class ApiConfig {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="required")
    private Boolean required = null;
    @SerializedName(value="default")
    private String _default = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="relatedName")
    private String relatedName = null;
    @SerializedName(value="sensitive")
    private Boolean sensitive = null;
    @SerializedName(value="validationState")
    private ValidationState validationState = null;
    @SerializedName(value="validationMessage")
    private String validationMessage = null;
    @SerializedName(value="validationWarningsSuppressed")
    private Boolean validationWarningsSuppressed = null;

    public ApiConfig name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Readonly. The canonical name that identifies this configuration parameter.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiConfig value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The user-defined value. When absent, the default value (if any) will be used. Can also be absent, when enumerating allowed configs.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ApiConfig required(Boolean required) {
        this.required = required;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. Whether this configuration is required for the object. If any required configuration is not set, operations on the object may not work.")
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public ApiConfig _default(String _default) {
        this._default = _default;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. The default value.")
    public String getDefault() {
        return this._default;
    }

    public void setDefault(String _default) {
        this._default = _default;
    }

    public ApiConfig displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. A user-friendly name of the parameters, as would have been shown in the web UI.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiConfig description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. A textual description of the parameter.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiConfig relatedName(String relatedName) {
        this.relatedName = relatedName;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. If applicable, contains the related configuration variable used by the source project.")
    public String getRelatedName() {
        return this.relatedName;
    }

    public void setRelatedName(String relatedName) {
        this.relatedName = relatedName;
    }

    public ApiConfig sensitive(Boolean sensitive) {
        this.sensitive = sensitive;
        return this;
    }

    @ApiModelProperty(value="Readonly. Whether this configuration is sensitive, i.e. contains information such as passwords, which might affect how the value of this configuration might be shared by the caller.  Available since v14.")
    public Boolean getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public ApiConfig validationState(ValidationState validationState) {
        this.validationState = validationState;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. State of the configuration parameter after validation.")
    public ValidationState getValidationState() {
        return this.validationState;
    }

    public void setValidationState(ValidationState validationState) {
        this.validationState = validationState;
    }

    public ApiConfig validationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. A message explaining the parameter's validation state.")
    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public ApiConfig validationWarningsSuppressed(Boolean validationWarningsSuppressed) {
        this.validationWarningsSuppressed = validationWarningsSuppressed;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. Whether validation warnings associated with this parameter are suppressed. In general, suppressed validation warnings are hidden in the Cloudera Manager UI. Configurations that do not produce warnings will not contain this field.")
    public Boolean getValidationWarningsSuppressed() {
        return this.validationWarningsSuppressed;
    }

    public void setValidationWarningsSuppressed(Boolean validationWarningsSuppressed) {
        this.validationWarningsSuppressed = validationWarningsSuppressed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiConfig apiConfig = (ApiConfig)o;
        return Objects.equals(this.name, apiConfig.name) && Objects.equals(this.value, apiConfig.value) && Objects.equals(this.required, apiConfig.required) && Objects.equals(this._default, apiConfig._default) && Objects.equals(this.displayName, apiConfig.displayName) && Objects.equals(this.description, apiConfig.description) && Objects.equals(this.relatedName, apiConfig.relatedName) && Objects.equals(this.sensitive, apiConfig.sensitive) && Objects.equals((Object)this.validationState, (Object)apiConfig.validationState) && Objects.equals(this.validationMessage, apiConfig.validationMessage) && Objects.equals(this.validationWarningsSuppressed, apiConfig.validationWarningsSuppressed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.required, this._default, this.displayName, this.description, this.relatedName, this.sensitive, this.validationState, this.validationMessage, this.validationWarningsSuppressed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiConfig {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    relatedName: ").append(this.toIndentedString(this.relatedName)).append("\n");
        sb.append("    sensitive: ").append(this.toIndentedString(this.sensitive)).append("\n");
        sb.append("    validationState: ").append(this.toIndentedString((Object)this.validationState)).append("\n");
        sb.append("    validationMessage: ").append(this.toIndentedString(this.validationMessage)).append("\n");
        sb.append("    validationWarningsSuppressed: ").append(this.toIndentedString(this.validationWarningsSuppressed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

