/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.openid;

import com.github.scribejava.apis.openid.OpenIdOAuth2AccessToken;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import java.util.regex.Pattern;

public class OpenIdJsonTokenExtractor
extends OAuth2AccessTokenJsonExtractor {
    private static final Pattern ID_TOKEN_REGEX_PATTERN = Pattern.compile("\"id_token\"\\s*:\\s*\"(\\S*?)\"");

    protected OpenIdJsonTokenExtractor() {
    }

    public static OpenIdJsonTokenExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected OpenIdOAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String response) {
        return new OpenIdOAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, OpenIdJsonTokenExtractor.extractParameter((String)response, (Pattern)ID_TOKEN_REGEX_PATTERN, (boolean)false), response);
    }

    private static class InstanceHolder {
        private static final OpenIdJsonTokenExtractor INSTANCE = new OpenIdJsonTokenExtractor();

        private InstanceHolder() {
        }
    }
}

