/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AggregateNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CountNode
extends AggregateNode {
    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            String attrName = this.getLeft().isDotNode() ? this.resolveAttribute() : "COUNT";
            reportQuery.addAttribute(attrName, this.generateExpression(context), Long.class);
        }
    }

    @Override
    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            this.left.validate(context);
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.getLongClassType());
        }
    }

    @Override
    protected Expression addAggregateExression(Expression expr) {
        return expr.count();
    }

    @Override
    public boolean isCountNode() {
        return true;
    }

    @Override
    public String getAsString() {
        return "COUNT(" + this.left.getAsString() + ")";
    }
}

