/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.comparators.DnComparator;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnSerializer
extends AbstractElementSerializer<Dn> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DnSerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Comparator<Dn> comp = new Comparator<Dn>(){
        DnComparator comparator = new DnComparator(null);

        @Override
        public int compare(Dn dn1, Dn dn2) {
            return this.comparator.compare((Object)dn1, (Object)dn2);
        }
    };

    public DnSerializer() {
        super(comp);
    }

    public byte[] serialize(Dn dn) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            dn.writeExternal((ObjectOutput)out);
            out.flush();
            if (IS_DEBUG) {
                LOG.debug(">------------------------------------------------");
                LOG.debug("Serialized " + dn);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Dn deserialize(ByteBuffer buffer) throws IOException {
        return this.deserialize(new BufferHandler(buffer.array()));
    }

    public Dn deserialize(BufferHandler bufferHandler) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bufferHandler.getBuffer()));
        try {
            Dn dn = new Dn();
            dn.readExternal((ObjectInput)in);
            return dn;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_134, (Object[])new Object[]{cnfe.getLocalizedMessage()}));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }

    public Dn fromBytes(byte[] buffer) throws IOException {
        return this.fromBytes(buffer, 0);
    }

    public Dn fromBytes(byte[] buffer, int pos) throws IOException {
        int length = buffer.length - pos;
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer, pos, length));
        try {
            Dn dn = new Dn();
            dn.readExternal((ObjectInput)in);
            return dn;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_134, (Object[])new Object[]{cnfe.getLocalizedMessage()}));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }

    public Class<?> getType() {
        return Dn.class;
    }
}

